PROGRAM Config;
  {  CONFIG.C written in C by Mike Klein, CompuServe ID 73237,2531 }
  {  version 1.6 published in LAN Technology magazine, 9/89 issue  }
  {  The author's address then was: 10951 Sorrento Valley Rd. #1F  }
  {                                 San Diego, CA 92121            }
  {  The published source code did not claim to be copyrighted,    }
  {  and could be downloaded from a bulletin board at 603/882-1599 }
  {  which no longer appears to be in operation.                   }
  {  To whatever extent I have the right to do so, I likewise      }
  {  leave this Pascal version free of copyright, asking only that }
  {  improved versions be likewise posted for the benefit of all.  }
  {  Compiled with Turbo Pascal 6. Requires at least version 4.    }
  {                                                                }
  {  8/10/91 JFS v2.10 Altered to replace CONFIG.C                 }
  { 10/11/91 JFS v2.11 Replace OS_VER with Novell-style OS_VERSION }
  { 11/07/91 JFS v2.12 Limit PSTAT to 8 characters                 }
  {              This allows it to be used as a DOS filename       }
  { 10/18/92 JFS v2.16 Allow saving results to file on disk.       }
  {              triggered by a new command line parameter /F path }
  {              Also allow versions of DOS beyond 9.99, and only  }
  {              truncate PSTAT as an EVAR, not to screen or disk. }
  { 10/22/92 JFS v2.17 Shorten data items when stored to disk,     }
  {         & MM especially if name is LAB or GUEST. Also replace  }
  {              Novell routines that used a no-longer-free        }
  {              library with netInfo unit by Mike McCall that is  }
  {              freely-copyable.                                  }
  { 10/28/92 JFS v2.18 Add station & socket numbers to netinfo, &  }
  {         & MM optimize source code to shorten & cut units.      }
  {              Don't use yet. Alters EVARs improperly.           }
  {                                                                }
  { The first command line parameter is /E                         }
  { If present, several DOS environment variables are set          }
  {             and the program generates no output to screen.     }
  { An alternative command line parameter is /F                    }
  { It works exactly like /E, but also saves its variables         }
  { in a DOS text file in the path specified after /F, & includes  }
  { the year & month in the file name in the form YYM, where       }
  { YY is the 2 low-order digits of the year, & M is the month,    }
  { letting A=October, B=November & C=December.                    }
  { e.g. the command CONFIG /F Y:\SHARED\, if executed 10/17/92,   }
  { creates or appends data to disk file Y:\SHARED\CFG92A.TXT      }
  { In addition this option adds the system date & time & the      }
  { user's login and full name to the data saved to disk.          }
  { When no command line parameters are given, results appear      }
  { only on screen, & are not written to either disk or EVARs.     }

{$B-,D-,F-,I-,L+,N-,R-,S-,V-}
{$M 4096,0,0}

USES Adapter, NetInfo;

CONST
  NetError : byte = 0;          { netInfo return value - if zero, all ok }

TYPE
  Str1Type      = string [1];
  Str2Type      = string [2];
  Str3Type      = string [3];
  Str4Type      = string [4];
  Str5Type      = string [5];
  Str6Type      = string [6];

VAR
  F             : text;         { Optionally stores results to disk       }
  fil_path,                     { Path along which to store file          }
  fil_nam       : string;       { Full path & file name to use            }


  {Variables used to find and change DOS environment}
  UseCurrentEnv,                { True if current environment is accessed }
  SecondCommand : boolean;      { True if secondary COMMAND.COM is loaded }
  AL,                           { Register AL                             }
  EnvTyp        : byte;         { Environment type                        }
  EnvAddr,                      { Environment address                     }
  AX,                           { Register AX                             }
  RootEnvAddr   : word;         { Root environment address                }
  EnvSize,                      { Environment size                        }
  RootEnvSize,                  { Root environment size                   }
  i             : integer;      { Temporary loop index                    }
  EnvStr,
  EnvVar        : string;

  {Variables used to find machine configuration}
  exp,                          { Expanded memory? (T/F)         }
  ext,                          { Extended memory? (T/F)         }
  fpu,                          { FPU present? (T/F)             }
  vtyp,                         { Video type code from Adapter   }
  mouse         : Str1Type;     { Mouse present? (T/F)           }
  ddr,                          { Current data drive for results }
  dd,                           { Current day of month           }
  class         : Str2Type;     { Like model, but only (PC/AT)   }
  yym           : Str3Type;     { Current year & month           }
  conv,                         { Conventional memory size       }
  cpu,                          { CPU type (808x, 80286, 80386)  }
  video         : Str4Type;     { Video adapter (MDA, HERC, CGA, }
                                {                EGA, PGA, VGA)  }
  hhmm,                         { Current hour & minute          }
  os_version    : Str5Type;     { DOS version number             }
  mode,                         { Video mode (COLOR/MONO)        }
  free          : Str6Type;     { Free conventional memory       }
  netaddr,                      { LAN network address            }
  pstat2,
  pstat,                        { LAN physical node number       }
  stn,                          { Connection # of station as str }
  sock,                         { Socket as str                  }
  name,                         { User's login name              }
  fullname      : string;       { User's full name               }

  env_set,                      { Flags whether to set EVARs     }
  fil_set       : boolean;      { Flags whether to write to file }
  Major,                        { Major DOS version number       }
  Minor,                        { Minor DOS version number       }
  station,                      { Connection # of station        }
  year,
  month,
  day,                          { System date                    }
  hr,
  min,                          { System time                    }
  byt           : byte;
  g_driver,                     { Graphic driver type found      }
  g_mode        : integer;      { Current mode of graphic driver }
  socket,                       { Socket number on network       }
  memval,
  CPUval,
  far_ptr       : word;
  have          : longint;

PROCEDURE GetEnvTyp(VAR EnvTyp : byte);
{Which type of DOS and environment type is on this PC?}

begin {GetEnvTyp}
  { Assign environment type according to DOS version }
  inline ($B4/$30           (* mov ah, 30                     *)
         /$CD/$21           (* int 21  Get DOS version number *)
         /$A2/Major         (* mov Major, al                  *)
         /$88/$26/Minor);   (* mov Minor, ah                  *)

  EnvTyp := 3;
  case Major of
    2 : EnvTyp := 1;
    3 : case Minor of
          0, 10 : EnvTyp := 1;
          20    : EnvTyp := 2
        end { case Minor }
  end { case Major }
end; { GetEnvTyp }

PROCEDURE SearchMemory(VAR RootEnvaddr : word; VAR RootEnvSize : integer);
{ Search memory for root environment }

VAR
  ComMCB  : word;     { COMMAND.COM MCB }
  EnvMCB  : word;     { environment MCB }
  MCBsize : word;     { memory block size in paragraphs }
  Found   : boolean;  { root COMMAND.COM found }

  PROCEDURE CheckMCBchain(ComMCB : word; VAR EnvMCB : word;
                          VAR Found : boolean);
  { Check for Memory Control Block chain }

  begin { CheckMCBchain }
    Found   := false;
    MCBsize := MemW[ComMCB : 3];
    EnvMCB  := Succ(ComMCB + MCBsize);
    if (Mem[EnvMCB : 0] = $4D) then
      Found := true;
  end; { CheckMCBchain }

begin { SearchMemory }
  { Begin search for COMMAND.COM in low memory }
  ComMCB := $500;
  Found  := false;
  while not Found do
    begin {while}
      { MCB begins with $4D }
      if Mem[ComMCB:0] = $4D then
        begin { if }
          { check for matching PSP address }
          if MemW[ComMCB : 1] = Succ(ComMCB) then
            CheckMCBchain(ComMCB,EnvMCB,Found);
        end; { if }

      { If not Found then continue search at next paragraph boundary }
      Inc(ComMCB);
    end; { while }

  { Check for environment type }
  if MemW[ComMCB : $2C] = 0 then
    { Root environment of DOS 2.0 - 3.2 }
    begin { if }
      RootEnvAddr := Succ(EnvMCB);
      MCBsize := MemW[EnvMCB : 3];
      RootEnvSize := MCBsize * $10
    end { if }
  else
    { Root environment of DOS 3.3 and later }
    begin { else }
      RootEnvAddr := MemW[ComMCB : $2C];
      EnvMCB := Pred(RootEnvaddr);
      MCBsize := MemW[EnvMCB : 3];
      RootEnvSize := MCBsize * $10
    end { else }
end;  { SearchMemory }

PROCEDURE GetActivEnv(VAR EnvAddr : word; VAR EnvSize : integer;
                      VAR RootEnvAddr : word; VAR RootEnvSize : integer;
                      EnvTyp : byte);
{ Get active environment }

VAR
  PSPaddr,         { COMMAND.COM PSP address }
  ComMCB,          { COMMAND.COM MCB }
  EnvMCB,          { environment MCB }
  MCBsize : word;  { memory block size in paragraphs }

begin { GetActivEnv }
  RootEnvAddr := 0;

  { COMMAND.COM PSP address at offset $16 in program PSP }
  PSPaddr := MemW[PrefixSeg : $16];

  { check for child process }
  while (PSPaddr <> MemW[PSPaddr : $16]) do
    PSPaddr := MemW[PSPaddr : $16];

  { COMMAND.COM MCB address }
  ComMCB := Pred(PSPaddr);

  { Size of COMMAND.COM }
  MCBsize := MemW[ComMCB : 3];

  { Environment MCB address }
  EnvMCB := PSPaddr + MCBsize;

  { Assign environment address }
  EnvAddr := Succ(EnvMCB);

  { Size of environment }
  MCBsize := MemW[EnvMCB : 3];
  EnvSize := MCBsize * $10;

  { Check for secondary COMMAND.COM }
  case EnvTyp of
    { $2C points to DOS environment in DOS 2.0 - 3.1 }
    1 : if (MemW[PSPaddr : $2C] <> 0) then
          begin { case 1 }
            SearchMemory(RootEnvAddr,RootEnvSize);
            { Re-assign environment address }
            EnvAddr := MemW[PSPaddr : $2C];
            EnvMCB := Pred(Envaddr);
            MCBsize := MemW[EnvMCB : 3];
            EnvSize := MCBsize * $10
          end; { case 1 }
        { $2C points to program environment in DOS 3.2 }
    2 : if (MemW[PSPaddr : $2C] <> 0) then
          SearchMemory(RootEnvAddr,RootEnvSize);
        { $2C points to DOS environment in DOS 3.3 and later }
    3 : if (MemW[PSPaddr : $2C] = EnvAddr) then
          SearchMemory(RootEnvAddr,RootEnvSize)
        else
        { Re-assign environment address }
          begin { case 3 else }
            EnvAddr := MemW[PSPaddr : $2C];
            EnvMCB := Pred(Envaddr);
            MCBsize := MemW[EnvMCB : 3];
            EnvSize := MCBsize * $10
          end { case 3 else }
  end { case }
end;  { GetActivEnv }

FUNCTION UpStr(St : string) : string;
{ Convert a string to upper case }

VAR
  i : byte;

begin { UpStr }
  for i := 1 to Length(St) do
    St[i] := UpCase(St[i]);
  UpStr := St
end;  { UpStr }

FUNCTION TrimLeft(St :string) : string;
{ Delete leading zeroes from numeric string }

VAR
  i,
  j : Integer;

begin { TrimLeft }
  i := 1;
  j := Length(St) + 1;
  while (St[i] = '0') do
    Inc(i);
  TrimLeft := Copy(St, i, j - i);
end; { trimLeft }

FUNCTION EnvStrLength (EnvAddr, EnvSize : word) : word;
{ Get length of a string in DOS environment }

var p : word;

begin { EnvStrLength }
  p := 0;
  while memW [EnvAddr : p] <> 0 do
      inc (p);
  if p > EnvSize then
    begin { if }
      Writeln('End of environment not found');
      Halt
    end; { if }
  EnvStrLength := p;
end;  { EnvStrLength }

FUNCTION Position(St : string; EnvAddr : word; ArrayLen : integer) : integer;
{ Find the position of a string in DOS environment }

VAR
  p     : integer;
  i     : integer;
  match : boolean;

begin { Position }
  St    := St + '=';
  { Check for first string in environment space }
  match := true;
  for i := 1 to Length(St) do
    if Mem[EnvAddr : i - 1] <> Ord(St[i]) then
      begin  { if }
        match := false;
        i     := Length(St)
      end;   { if }
  if match then
    begin  { if }
      Position := 0;
      exit
    end;   { if }
  p := 0;
  while p < ArrayLen do
    begin  { while }
      while (Mem[EnvAddr : p] <> 0) do
        inc (p);  { Skip to beginning of next environment entry }
      inc (p);
      match := true;
      for i := 1 to Length(St) do
        if Mem[EnvAddr : p + i - 1] <> Ord(St[i]) then
          begin  { if }
            match := false;
            i := Length(St)
          end; { if }
      if match then
        begin  { if }
          Position := p;
          exit
        end; { if }
    end; { while }
  Position := -1
end; { Position }

PROCEDURE WriteEnvVar(EnvParam, EnvVar : string);
{ Write an environment variable to DOS environment }

VAR
  EnvStr   : string;   { Environment string        }
  ArrayLen,            { Environment array length  }
  StLen,               { Environment string length }
  ParamPos,            { Parameter position        }
  i        : integer;

begin { WriteEnvVar }
  if EnvParam = '' then
    Exit;
  if not UseCurrentEnv then
    begin { if }
      EnvAddr := RootEnvAddr;
      EnvSize := RootEnvSize;
    end; { if }

  { Get the length of the environment string }
  ArrayLen := EnvStrLength (EnvAddr, EnvSize);

  { Initialize variables }
  EnvParam := UpStr(EnvParam);
  EnvStr := EnvParam + '=' + EnvVar + #0#0;
  StLen := Length(EnvStr);

  { Search for variable in environment }
  ParamPos := Position(EnvParam,EnvAddr,ArrayLen);

  if ParamPos = -1 then
    begin { if }
      { Check for empty variable }
      if EnvVar = '' then
        Exit;

      { Environment parameter not found }
      { Compare environment with string }
      if (ArrayLen + StLen + 1) > EnvSize then
        Writeln('Environment full')
      else
        { Add new variable string to end of array }
        begin { else }
          if ArrayLen = 0 then
            Move(EnvStr[1], Mem[EnvAddr : 0], StLen)
          else
            Move(EnvStr[1], Mem[EnvAddr : ArrayLen+1], StLen)
          end {else}
    end {if}
    { Environment parameter found }
    { Get length of variable string }
  else
    begin {else}
      { Start at =, skipping variable string }
      i := ParamPos + Length(EnvParam);
      while Mem[EnvAddr : i] <> 0 do
        Inc(i);

      { Get beginning of next variable string }
      Inc(i);

      { Delete variable from current position in array }
      Move(Mem[EnvAddr: i], Mem[EnvAddr: ParamPos], (ArrayLen + 2) - i);
      ArrayLen := ArrayLen - (i - ParamPos);

      { Check for empty variable }
      if EnvVar = '' then
        Exit;

      { Compare environment array length with environment size }
      if (ArrayLen + StLen + 1) > EnvSize then
        Writeln('Environment full')
      else
        { Add variable to end of array }
        Move(EnvStr[1], Mem[EnvAddr : ArrayLen+1], StLen)
    end { else }
end; { WriteEnvVar }

FUNCTION CPUis : word;
{ Identify microprocessor currently in use - NOTE: calls a 486 a 386 }

begin { CPUis }
  inline (
  $9C/          {pushf           }
  $31/$C0/      {xor  ax,ax      }
  $50/          {push  ax        }
  $9D/          {popf            }
  $9C/          {pushf           }
  $58/          {pop  ax         }
  $25/$00/$F0/  {and  ax,0f000h  }
  $3D/$00/$F0/  {cmp  ax,0f000h  }
  $74/$16/      {jz    is_808x   }

  { If we can't set bits 12-14, CPU is a 286 }
  $B8/$00/$70/  { mov  ax,07000h }
  $50/          { push  ax       }
  $9D/          { popf           }
  $9C/          { pushf          }
  $58/          { pop  ax        }
  $25/$00/$70/  { and  ax,07000h }
  $74/$05/      { jz    is_80286 }

  { is_80386 }
  $B8/$86/$03/  { mov  ax,386h   }
  $EB/$08/      { jmp  done      }
  { is_80286 }
  $B8/$86/$02/  { mov  ax,286h   }
  $EB/$03/      { jmp  done      }
  {is_808x}
  $B8/$86/$00/  { mov  ax,86h    }
  { done }
  $9D/          { popf           }
  $89/$46/$FE)  { mov  [bp-2],ax }
end; { CPUis }

begin { Config }
  env_set := false;
  fil_set := false;
  if ParamCount > 0 then
    begin { if }
      if ((ParamStr(1) = '/E') or  (ParamStr(1) = '/e')) then
        env_set := true
      else
       if ((ParamStr(1) = '/F') or  (ParamStr(1) = '/f')) then
         begin { if }
           env_set := true;
           fil_set := true;
           { Default path is root of current drive }
           fil_path := '\';
           { Read path specified after /F, if one was specified }
           if ParamCount > 1 then
             fil_path := ParamStr(2);
           { If specified path doesn't end with backslash, add one }
           if (fil_path[Length(fil_path)] <> '\') then
             fil_path := fil_path + '\'
         end { if }
       else
         begin { else }
           Writeln;
           Writeln('ERROR: Bad parameter...');
           Writeln(' Syntax is: CONFIG to display setup');
           Writeln(' or CONFIG /E to fill DOS environment with setup');
           Writeln(' or CONFIG /F [path] to file setup to disk file');
           Halt
         end {else}
    end; { if }

  { Initialize environment address }
  UseCurrentEnv := true;
  SecondCommand := true;
  GetEnvTyp(EnvTyp);
  GetActivEnv(EnvAddr,EnvSize,RootEnvAddr,RootEnvSize,EnvTyp);
  if RootEnvAddr = 0 then
    begin { if }
      RootEnvAddr := EnvAddr;
      RootEnvSize := EnvSize;
      SecondCommand := false
    end; { if }

  if (env_set = false) then
    begin { if }
      Writeln;
      Writeln;
      Writeln('SYSTEM CONFIGURATION v2.18');
      Writeln('==========================')
    end; { if }

  {************************************************}
  {* SYSTEM DATE & TIME - FROM DOS OR FILE SERVER *}
  {************************************************}

  pstat    := 'N/A';
  pstat2   := 'N/A';
  netaddr  := 'N/A';
  stn      := 'N/A';
  sock     := 'N/A';
  name     := 'N/A';
  fullname := 'N/A';

  {First see which test to use}
  inline ($B4/$DB    { mov ah, DB                 }
         /$CD/$21    { int 21                     }
         /$A2/AL);   { mov turbo_variable_AL, al  }

  if (AL = 0) then
    {IPX is NOT loaded, so use DOS}
    begin { if }
      {Get system date from DOS: year=0..99, month=1..12, day=1..31}
      inline ($B4/$2A          { mov ah, 2a        }
             /$CD/$21          { int 21  get date  }
             /$88/$36/month    { mov month, DH     }
             /$88/$16/day      { mov day, DL       }
             /$89/$C8          { mov AX, CX        }
             /$BB/$64/$00      { mov BX, 64        }
             /$31/$D2          { xor DX, DX        }
             /$F7/$F3          { div BX            }
             /$88/$16/year);   { mov year, DL      }

      { Get system time from DOS: hr=0..23, min=0..59 }
      inline ($B4/$2C          { mov ah, 2C        }
             /$CD/$21          { int 21  get time  }
             /$88/$2E/hr       { mov hr, CH        }
             /$88/$0E/min);    { mov min, CL       }
    end { if }
  else
    begin { else }
      {Get from file server, along with:}

      {********************************}
      {* LAN ADDRESS, USER & FULLNAME *}
      {********************************}

      { Call MM LAN code: first line is a byte and a word }
      { line two line is all strings                      }
      { third line & result are all bytes                 }
      NetError := netInformation (station, socket,
                                  pstat, netaddr, name, fullname,
                                  year, month, day, hr, min      );

      if NetError = 0 then
        begin { if }
          pstat  := TrimLeft(UpStr(pstat));
          pstat2 := pstat;
          { Limit EVAR result to 8 low-order digits, for DOS filenames }
          if Length(pstat) > 8 then pstat := Copy(pstat, 5, 8);
          netaddr   := TrimLeft(UpStr(netaddr));
          { Convert station & socket to strings }
          Str(socket, sock);
          Str(station, stn)
        end { if }
    end; { else }

  { Convert Date to YYM & DD form }
  yym       := '000';
  dd        := '00';
  yym[1]    := Chr((year div 10) + 48);
  yym[2]    := Chr((year mod 10) + 48);
  if month > 9 then Inc(month, 7);
  yym[3]    := Chr(month + 48);
  dd[1]     := Chr((day div 10) + 48);
  dd[2]     := Chr((day mod 10) + 48);
  dd        := TrimLeft(dd);

  { Convert time to hh:mm form }
  hhmm      := '00:00';
  hhmm[1]   := Chr((hr  div 10) + 48);
  hhmm[2]   := Chr((hr  mod 10) + 48);
  hhmm[4]   := Chr((min div 10) + 48);
  hhmm[5]   := Chr((min mod 10) + 48);
  hhmm      := TrimLeft(hhmm);
  { Leave at least one character before the colon }
  if hhmm[1] = ':' then
    hhmm := '0' + hhmm;

  if (env_set) then
    begin { if }
      WriteEnvVar('NETADDR', netaddr);
      WriteEnvVar('PSTAT', pstat);
      WriteEnvVar('STATION', stn);
      { NOTE: un-REM next line to store socket as an EVAR }
    { WriteEnvVar('SOCKET', sock); }
      WriteEnvVar('NAME', name);
      { NOTE: un-REM next line to store fullname as an EVAR }
    { WriteEnvVar('FULLNAM', fullname); }

      if (fil_set) then
        begin { if }

          {***********************}
          {* OPEN OR CREATE FILE *}
          {***********************}

          fil_nam := fil_path + 'CFG' + yym + '.TXT';
          Assign(F, fil_nam);
          Append(F);
          if (IOResult <> 0) then
            { If file doesn't already exist, create it }
            Rewrite(F);
          Write(F,dd,',',hhmm);
          { Store N/A answers as empty fields }
          if netaddr = 'N/A' then
            Write(F,',')
          else
            Write(F,',',netaddr);
          if pstat2 = 'N/A' then
            Write(F,',')
          else
            Write(F,',',pstat2);
          Write(F,',',stn);
          { NOTE: un-REM next line if you want to file socket# }
        { Write(F,',',sock); }
          { NOTE: THE NEXT TEST IS SPECIFIC TO WIU. OTHERS MAY OMIT! }
          { It files anonymous usernames as 1 character to save disk space }
          if ((name = 'LAB') or (name = 'GUEST')) then
            Write(F,',',name[1],',""')
          else
            begin { else }
              if name = 'N/A' then
                Write(F,',')
              else
                Write(F,',',name);
              if fullname = 'N/A' then
                Write(F,',""')
              else
                Write(F,',"',fullname,'"')
            end { else }
        end { if }
    end { if }
  else
    begin { else }
      Writeln('NETADDR.....', netaddr);
      Writeln('PSTAT.......', pstat2);
      Writeln('STATION.....', stn);
      Writeln('SOCKET......', sock);
      Writeln('NAME........', name);
      Writeln('FULLNAM.....', fullname)
    end; { else }

  {**************}
  {* OS VERSION *}
  {**************}

  if Major <= $0A then
    os_version := Chr(Major + $30) + '.'
                + Chr((Minor DIV $0A) + $30)
                + Chr((Minor MOD $0A) + $30)
  else
    os_version := Chr((Major DIV $0A) + $30)
                + Chr((Major MOD $0A) + $30) + '.'
                + Chr((Minor DIV $0A) + $30)
                + Chr((Minor MOD $0A) + $30);

  if (env_set) then
    begin { if }
      WriteEnvVar('OS_VERSION', 'V'+os_version);
      if (fil_set) then
        Write(F,',',os_version)
    end { if }
  else
    Writeln('OS_VERSION..', 'V'+os_version);

  {************}
  {* CPU TYPE *}
  {************}

  CPUval := CPUis;

  case (CPUval) of
      $386 :
        begin { case 386 }
          cpu   := '386';
          class := 'AT'
        end; { case 386 }
      $286 :
        begin { case 286 }
          cpu   := '286';
          class := 'AT';
        end; { case 286 }
      $86 :
        begin { case 86 }
          cpu   := '808x';
          class := 'PC'
        end { case 86 }
      else
        begin { case else }
          cpu   := 'N/A';
          class := 'N/A'
        end { case else }
    end; { case }

  if (env_set) then
    begin { if }
      WriteEnvVar('CPU', cpu);
      WriteEnvVar('CLASS', class);
      if (fil_set) then
        Write(F,',',cpu[1]) { No need to file CLASS - obvious from CPU }
    end { if }
  else
    begin { else }
      Writeln('CPU.........', cpu);
      Writeln('CLASS.......', class)
    end; { else }

   {**************}
   {* MATH CHIP? *}
   {**************}

  inline ($CD/$11   {interrupt 11h, Get BIOS equip word for FPU}
         /$A3/AX);  {mov turbo_variable_ax, AX                 }
  if ((AX AND $02) <> $00) then
    fpu := 'T'
  else
    fpu := 'F';

  if (env_set) then
    begin { if }
      WriteEnvVar('FPU', fpu);
      if (fil_set) then
        Write(F,',',fpu)
    end { if }
  else
    Writeln('FPU.........', fpu);

  {***********************}
  {* CONVENTIONAL MEMORY *}
  {***********************}

  inline ($CD/$12                   { int 12                        }
         /$A3/memval);              { mov memval, AX                }
  if ((memval AND $0001) <> 0) then { Some systems report 1K less   }
    Inc(memval);                    { than actual, so we compensate }
  Str(memval, conv);

  if (env_set) then
    begin { if }
      WriteEnvVar('CONV', conv);
      if (fil_set) then
        Write(F,',',conv)
    end { if }
  else
    Writeln('CONV........', conv);

  {********************}
  {* FREE CONV MEMORY *}
  {********************}

  inline ($B4/$48             { mov AH, 48     }
         /$BB/$FF/$FF         { mov BX, FFFF   }
         /$CD/$21             { int 21         }
         /$89/$1E/memval);    { mov memval, BX }

  {We change 16 byte paragraphs to decimal bytes and add 33 because}
  {Config uses 33K of RAM itself}
  {Result is conservative - there may be 1-4K more RAM free than claimed}
  Str(memval SHR 6 + 33, free);

  if (env_set) then
    begin { if }
      WriteEnvVar('FREE', free);
      if (fil_set) then
        Write(F,',',free)
    end { if }
  else
    Writeln('FREE........', free);

  {*******************}
  {* EXPANDED MEMORY *}
  {*******************}

  inline ($B8/$67/$35        { mov AX, 3567    }
         /$CD/$21            { int 21          }
         /$8C/$06/far_ptr);  { mov far_ptr, ES }
  exp := 'T';
  {Look for EMMXXXX0 ID string}
  if Mem[far_ptr : 10] <> $45 then exp := 'F';
  if Mem[far_ptr : 11] <> $4D then exp := 'F';
  if Mem[far_ptr : 12] <> $4D then exp := 'F';
  if Mem[far_ptr : 13] <> $58 then exp := 'F';
  if Mem[far_ptr : 14] <> $58 then exp := 'F';
  if Mem[far_ptr : 15] <> $58 then exp := 'F';
  if Mem[far_ptr : 16] <> $58 then exp := 'F';
  if Mem[far_ptr : 17] <> $30 then exp := 'F';

  if (env_set) then
    begin { if }
      WriteEnvVar('EXP', exp);
      if (fil_set) then
        Write(F,',',exp)
    end { if }
  else
    Writeln('EXP.........', exp);

  {*******************}
  {* EXTENDED MEMORY *}
  {*******************}

  { This code must follow the CPU code  }
  ext := 'F';
  if (class = 'AT') then
    begin { if }
      inline ($B8/$00/$88    { mov AX, 8800    }
             /$CD/$15        { int 15          }
             /$A3/memval);   { mov memval, AX  }
      if ((memval <> $8800) AND (memval <> $0000)) then
        ext := 'T'
    end; { if }

  if (env_set) then
    begin { if }
      WriteEnvVar('EXT', ext);
      if (fil_set) then
        Write(F,',',ext)
    end { if }
  else
    Writeln('EXT.........', ext);

   {**********}
   {* MOUSE? *}
   {**********}

  inline ($B8/$00/$00     { mov AX, 0                               }
         /$CD/$33         { int 33   Mouse function 0 - initialize  }
         /$A3/AX);        { mov turbo_variable_ax, AX               }
  if (AX <> $0000) then
    mouse := 'T'
  else
    mouse := 'F';

  if (env_set) then
    begin { if }
      WriteEnvVar('MOUSE', mouse);
      if (fil_set) then
        Write(F,',',mouse)
    end { if }
  else
    Writeln('MOUSE.......', mouse);

  {**************}
  {* VIDEO MODE *}
  {**************}

  inline ($B8/$00/$0F    { mov AX, 0f00               }
         /$CD/$10        { int 10 - Video interrupt   }
         /$A2/al);       { mov turbo_variable_al, AL  }
  case (AL) of
     $00,
     $02,
     $07  : mode := 'MONO'
  else
    mode  := 'COLOR'
  end; { case }

  if (env_set) then
    begin { if }
      WriteEnvVar('MODE', mode);
      if (fil_set) then
        Write(F,',',mode[1])
    end { if }
  else
    Writeln('MODE........', mode);

   {*****************}
   {* VIDEO ADAPTER *}
   {*****************}

  vtyp := videoType; { From MM's Adapter unit }

  video := 'N/A';
  if vtyp = 'V' then video := 'VGA';
  if vtyp = 'E' then video := 'EGA';
  if (vtyp = 'C') or (vtyp = 'M') then video := 'CGA';
  if vtyp = 'H' then video := 'HERC';
  if vtyp = 'M' then video := 'MDA';

  if (env_set) then
    begin { if }
      WriteEnvVar('VIDEO', video);
      if (fil_set) then
        Writeln(F,',',video[1]);
        { All data sent - close file }
        Close(F)
    end { if }
  else
    Writeln('VIDEO.......', video)

end. { Config }
