# This file is an Msub script


# A script for converting <Tab>s in a text file to spaces.
# Assumes tab stops every 8 columns.
#
# Should be fast enough: One iteration per tab column in file.
# Plus it uses fully deterministic regexps.

# Abbreviations:
	# :t for the tab characters,
	# :x for any non-tab, non-lineseparating character.
	# :m for the sharp character "#" used as a text marker 
!:t=\9
!:x=[^\9$]
!:m="#"

# Sharps are used for tab stop marking, so first they must be removed
# Note: The exact length of the replace text must be 8*n+1 for some n
:m
"<Sharp!!>"

!newpass

# Introduce sharps at tab stops, starting at left margin
^
^:m


              # Implicit !newpass with !begin
!begin
!iterate=30
            # Works the tab stop marker rightwards, 8
            # columns at a time, changing tabs to spaces
            # in those eight columns (if there are any
	    # tabs in a column, the the tab will be the
	    # last char, as tab advances to the next column).

	    # First, columns with tabs:

:m`:x:x:x:x:x:x:x`:t
`" ":m

:m`:x:x:x:x:x:x`:t
`"  ":m

:m`:x:x:x:x:x`:t
`"   ":m

:m`:x:x:x:x`:t
`"    ":m

:m`:x:x:x`:t
`"     ":m

:m`:x:x`:t
`"      ":m

:m`:x`:t
`"       ":m

:m:t
"        ":m

		# Next, columns without tabs.
		# If there are 8 chars or more left, then
		# go on to the next column.


:m`:x:x:x:x:x:x:x:x`
`:m

!end

                # Fewer than 8 chars:
		# Done with this line, remove the sharp.

:m`:x:x:x:x:x:x:x$`
`

:m`:x:x:x:x:x:x$`
`

:m`:x:x:x:x:x$`
`

:m`:x:x:x:x$`
`

:m`:x:x:x$`
`

:m`:x:x$`
`

:m`:x$`
`

:m`$`
`

# Finally, bring back the removed sharps:
!newpass
"<Sharp!!>"
:m
