CODE    SEGMENT BYTE PUBLIC 'CODE'
ASSUME  CS:CODE,DS:CODE,ES:NOTHING,SS:NOTHING

ID      equ     128     ;the id character to find in the psp command tail
VTBL    equ     90h     ;place in psp where vector table is stored
MTBL    equ     (VTBL+400h) 

P00100  PROC
        ORG     0100h

go:     JMP	start

        DB      8,8,8           ;hide the jump

help    DB     'Marks memory so TSRs in low memory can be removed.'
        DB     13,10
        DB     'Multiple marks can be used, LIFO.'
        DB     13,10,'Syntax: tsr [i|r]',13,10
        DB      9,'to Install or Remove TSRs',13,10
        DB      'Send bugs to ejohnson@csn.org',13,10
        DB      'Public Domain',13,10,1Ah,8,32,'$'

     

;--------------------------------------------------------------------------


start:  
        mov     ax,ds:[2Ch]     ;release the environment memory block
        mov     es,ax           ;good for both install & remove
        mov     ah,049h
        int     21h
        xor     ax,ax
        mov     ds:[2Ch],ax     ;clear env ptr in psp

        mov     ax,cs
        mov     es,ax
        mov     si,offset r0                    ;relocate code
        mov     cx,offset r1- offset r0
        mov     di,4000h
        rep movsb

        ;jmp     4000h              ;to relocation
        db      0E9h
        dw      3E22h

;---------------------------------------------------------------------------

r0:     mov     al,cs:[82h]

        cmp     al,'r'
        jz      r
        cmp     al,'i'
        jz      i
        
        mov     dx,offset help
        mov     ah,9h
        int     21h
        
quit:   mov     ax,4C00h        ;end program
        int     21h

r:      jmp     REMOVE

i:      jmp     INSTALL

;--------------------------------------------------------------------------


lmcb    dw      0       ;last mcb found, 0 => not started yet
tblsz   dw      0       ;mcb table size
mcb     dw      0       ;mcb of tsr's install invocation 


;--------------------------------------------------------------------------

                        
MCBTBL  PROC    NEAR            ;store list of used mcbs at ds:di
                                ;last entry is 0000h
                                ;ax returns(paragraphs used for list)                

        push    cs
        pop     ds
                                                
        mov     ah,52h          ;get list of lists
        int     21h
        mov     ax,es:[bx-2]    ;ax = first MCB segment
        mov     es,ax           ;es is segment of mcb
        mov     lmcb,ax

        xor     cx,cx           ;count blocks stored
        
        mov     di,490h

agn:    mov     ax,lmcb
        mov     ds:[di],ax      ;store mcb block address
        inc     cx
        add     di,2

        mov     dx,lmcb   ;????

        mov     es,ax
again:  mov     al,es:[0]
        cmp     al,'Z'
        jz      done            ;j if no more mcbs

        mov     bx,es:[3]       ;get memory block size in paragraphs
        inc     bx              ;add 1 for mcb
        mov     ax,es           ;add this location
        add     bx,ax
        mov     es,bx           ;es points to next mcb

        mov     lmcb,bx         ;save mcb ??????????????????????
        
        mov     ax,es:[1]       ;is this mcb free?
        or      ax,ax
        jz      again           ;free mcb, so go find the next mcb

        mov     ax,es           ;don't save this programs mcb           
        mov     bx,cs
        dec     bx
        cmp     ax,bx
        jz      again

        mov     ax,es:[91h]     ;install block ?
        cmp     ax,ID     
        jnz     agn

        mov     ax,es           ;found 'INSTALL' mcb
        mov     mcb,ax
        jmp     agn             ;store block in table & continue

done:
        xor     ax,ax           ;terminate list with 0h
        mov     ds:[di],ax
        inc     cx
                                       
        shr     cx,3            ;count up mcb table size in paragraphs
        inc     cx
        mov     tblsz,cx
        ret
                

MCBTBL  ENDP

;---------------------------------------------------------------------------

COMPARE PROC    NEAR

;parameters
; in            ax = mcb segment to test
; out           clc = found, stc not found
;               ax unchanged

        mov     cx,mcb          ;es:di points to install mcb table
        mov     es,cx
        mov     di,4A0h

cag:    mov     cx,es:[di]      ;cx = table entry
        or      cx,cx
        jz      cdone           ;at 0000h end of table, so done

        cmp     ax,cx
        jz      cfound          ;found ?

        add     di,2
        jmp     cag


cfound: clc
        ret
cdone:  stc
        ret

COMPARE ENDP

;--------------------------------------------------------------------------


REMOVE  PROC    NEAR            ;remove back to last install

        call    MCBTBL   

        cli                     ;restore the vector table
        mov     ax,mcb          ;source
        or      ax,ax
        jnz      ra            ;no install happened, so quit
rb:     jmp     quit
ra:     mov     ds,ax
        mov     si,VTBL+10h
        xor     ax,ax           ;destination
        mov     es,ax
        mov     di,ax
        mov     cx,400h
        rep movsb               ;move it
        sti

        mov     si,490h         ;location of new mcb table ds:si
        push    cs
        pop     ds

ag:     mov     ax,ds:[si]
        or      ax,ax
        jz      rb              ;quit


        call    COMPARE
        jnc     keepit

        call    RELEASE
keepit: add     si,2
        jmp     ag


REMOVE  ENDP


;------------------------------------------------------------------------


RELEASE PROC    NEAR            ;release memory

        inc     ax              ;point to block, not mcb
        
        mov     bx,cs
        cmp     ax,bx
        jz      skip            ;don't release this program
        
        mov     es,ax
        mov     ah,049h
        int     21h
skip:   ret

RELEASE ENDP


;--------------------------------------------------------------------------



INSTALL PROC    NEAR            ;save vectors & mcbs

        mov     ax,ID           ;load ID byte
        mov     cs:[81h],ax     ;into PSP command tail

        xor     ax,ax           ;set source
        mov     ds,ax
        mov     si,ax
        mov     ax,cs           ;set destination
        mov     es,ax
        mov     di,VTBL
        cld
        mov     cx,1024         ;vector table size
        rep movsb               ;copy table
        
        call    MCBTBL

        mov     dx,tblsz        ;paragraphs
        add     dx,40h-7h+10h

        MOV	ah,31h          
	int	21h             ;TSR
r1:


INSTALL ENDP


;--------------------------------------------------------------------------

P00100  ENDP

CODE    ENDS
        END     go
 


