/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* finance.h  -  header file for finance.c - financial functions */

#ifndef FINANCE_HEADER
#define FINANCE_HEADER  1

#include <howard.h>

#define SLD(c,s,l)          straight_line_dep(c,s,l)
#define SYD(c,s,l,p)        sum_year_digits_dep(c,s,l,p)
#define DDB(c,l,p)          double_decline_bal_dep(c,l,p)
#define ACC_SLD(c,s,l)      accum_dep(c,s,l,0,1)
#define ACC_SYD(c,s,l,p)    accum_dep(c,s,l,p,2)
#define ACC_DDB(c,l,p)      accum_dep(c,0,l,p,3)

/* function prototypes */
double straight_line_dep(double cost, double salvage, int life);
double sum_year_digits_dep(double cost, double salvage, int life, int period);
double double_decline_bal_dep(double cost, int life, int period);
double depreciation(double cost, double salvage, int life, int period, int dtype);
double accum_dep(double cost, double salvage, int life, int period, int dtype);
double PMT(double principal, double interest, int periods);
double PV(double payment, double interest, int periods);
double PVa(double payment, double interest, int periods);
double FV(double payment, double interest, int periods);
double FVa(double payment, double interest, int periods);

#endif              /* FINANCE_HEADER */
