/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* multihk.h  -  header file for multihk.h - multitasking routines */

#ifndef MULTIHK_HEADER
#define MULTIHK_HEADER  1

#include <howard.h>
#include <alloc.h>              /* for size_t */

/* NOTE: most DESQ functions are really DESQview/TopView/TaskView(Omniview) */

typedef struct DESQmemory {
                int memavail;               /* memory available */
                int largestblockavail;      /* largest block available */
                int totalmem;               /* total memory */
            };

#define DVERROR_BEEP    0x8000          /* make a beep */
#define DVERROR_LEFT    0x2000          /* left button removes window */
#define DVERROR_RIGHT   0x4000          /* right button removes window */
#define DVERROR_EITHER  0x0000          /* either button removes window (also 0x6000) */


/* function prototypes - DESQview */
unsigned DESQappnum(void);              /* program number as it appears on "Switch Windows" menu */
void DESQbeginc(void);                  /* DESQview begin critical region */
void DESQcommonmem(struct DESQmemory *dm);  /* common memory available */
void DESQconvenmem(struct DESQmemory *dm);  /* conventional memory available */
unsigned DESQdisperror(char *msg, unsigned char width, unsigned char height, unsigned segment, unsigned flags); /* popup error window */
void DESQendc(void);                    /* DESQview end critical region */
void DESQexit(void);                    /* DESQview (Topview???) exit program */
void DESQexpandedmem(struct DESQmemory *dm);/* expanded memory available */
char far *DESQgetbuf(unsigned segment, unsigned *size);  /* get DESQview virtual screen info */
char far *DESQgetmem(size_t size);      /* DESQview allocate "system" memory */
void DESQjustify(boolean enable);       /* enable/disable automatic window justification */
boolean DESQiskmouse(void);             /* using keyboard mouse ? */
void DESQkmouse_on(void);               /* turn keyboard mouse on */
void DESQkmouse_off(void);              /* turn keyboard mouse off */
void DESQostack(void);                  /* switch to task's internal stack */
void DESQpause(void);                   /* give up CPU time */
char DESQpoke(char c);                      /* display character on status line */
void DESQposttask(unsigned segment);    /* awaken DESQview task */
void DESQpushkey(unsigned scancode);    /* put key into keyboard input stream */
void DESQputmem(char far *block);       /* DESQview deallocate "system" memory */
void DESQsound(int frequency, int duration);    /* Make Tone under DESQview (Topview???) */
void DESQstart(unsigned segment);       /* indicated task is started up again */
void DESQstop(unsigned segment);        /* indicated task no longer gets cpu time */
void DESQustack(void);                  /* switch back to user's stack */
unsigned int DESQversion(void);         /* get version */
char far *getDESQvidbuffer(unsigned segment, unsigned offset);  /* get ptr to video buffer under DESQview */
void updateDESQdisplay(unsigned n, unsigned segment, unsigned offset);  /* update display from DESQview video buffer */
unsigned int DESQapilevel(unsigned char major, unsigned char minor);    /* define minimum API level required */

/* function prototypes - Double DOS */
void DoubleDOSfreeCPU(byte slices);     /* gives up slices * 55ms */
unsigned int DoubleDOSGetVirtual(void); /* get Double DOS virtual screen address */
void DoubleDOSTaskSwitch(boolean on);   /* set Double DOS task switching on/off */
boolean isDoubleDOS(void);              /* is Double DOS active */
boolean isInvisible(void);              /* is this the invisible program under Double DOS */

/* function prototypes - Taskview (Omniview ?) */
void TVprintc(char c, char attribute, unsigned segment);    /* display a character/attribute on screen */

#endif              /* MULTIHK_HEADER */
