/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* printhk.h  -  header file for printer routines */

#ifndef PRINTHK_HEADER
#define PRINTHK_HEADER  1

#define PRTSC_STATUS    *((byte far *) 0x500lu)    /* PrtSc status byte */
#define PRTSC_DONE      0x00           /* PrtSc completed */
#define PRTSC_CURRENT   0x01           /* PrtSc currently in progress */
#define PRTSC_ERROR     0xFF           /* error during printing */

#define PRINT_OK        0x00           /* PRINT.COM not installed, OK to install */
#define PRINT_NOOK      0x01           /* PRINT.COM not installed, NOT OK to install */
#define PRINT_INSTALLED 0xFF           /* PRINT.COM is installed */
#define PRINT_ERROR     0x7F           /* error code: try DOS 3.1 or greater */

/* PRINT error return codes */
#define PRINT_FINVALID      1          /* Function invalid */
#define PRINT_FILENOTFOUND  2          /* File not found */
#define PRINT_PATHNOTFOUND  3          /* Path not found */
#define PRINT_TOOMANYOPEN   4          /* Too many open files */
#define PRINT_ACCESSDENIED  5          /* Access denied */
#define PRINT_QUEUEFULL     8          /* Queue full */
#define PRINT_SPOOLERBUSY   9          /* Spooler busy */
#define PRINT_NAMETOOLONG   0x0C       /* Name too long */
#define PRINT_DRIVEINVALID  0x0F       /* drive invalid */


/* function prototypes */
int print_screen(void);                     /* print screen via INTerrupts */
int isPRINTavail(void);                     /* is PRINT.COM installed */
int PRINTadd(char *filename, int level);    /* no wildcards in filename */
int PRINTremove(char *filename, int level); /* wildcards (*,?) allowed */
int PRINTpurge(void);                       /* purge queue */
int PRINThold(char far *queue);             /* hold/pause queue and get status */
int PRINTresume(void);                      /* resume print, after PRINThold() */

#endif              /* PRINTHK_HEADER */
