;;; Initialisation file for Common Lisp to provide compatibility for Lisp-stuff
;;; that comes from XLISP (V1.7)
(setq *gc-verbose* nil)
(defun divide (x y) (floor x y))
(defun openo (filename)
  (open filename :direction :output :if-exists :new-version))
(defun openi (filename)
  (open filename :if-does-not-exist nil))
(defun flatsize (thing)
  (length (prin1-to-string thing)))
(defun flatc (thing)
  (length (princ-to-string thing)))
(defun transcript (&optional filename)
  (if filename (dribble filename) (dribble)))
(defun putprop (sym val prop)
  (setf (get sym prop) val))
(defun clock ()
  (round (get-internal-real-time) internal-time-units-per-second))
(defun strcat (str1 str2) (concatenate 'string str1 str2))
(defun readln (&optional stream)
  (if stream (read-line stream nil) (read-line *standard-input* nil)))

