TITLE	DSIZE	1-19-85	[4-16-88]
;Toad Hall Disassembly, tweak

LF	EQU	0AH
CR	EQU	0DH
;
;INITIAL VALUES :	CS:IP	0000:0100
;			SS:SP	0000:FFFF
CodeSeg	SEGMENT
	ASSUME DS:CodeSeg,SS:CodeSeg,CS:CodeSeg,ES:CodeSeg
	ORG 5CH
curdrive	db	?

	ORG	100H

Dsize	proc	near
	CMP	AL,0FFH			;No current drive?
	JNZ	ChkDos			; nope, continue
	 MOV	DX,OFFSET BadDrvMsg	;'Invalid drive specifier'
	 jmp	short Die

ChkDos:	MOV	AH,30H			;Get Dos version
	INT	21H
	or	al,al			;TH major version (0 if <2.0)
	JNZ	GetSpecs		; nope, keep going
	 MOV	DX,OFFSET Dos2Msg	;'Dos 2.0 or higher'
	 jmp	short Die

GetSpecs:
;	MOV	DL,DS:5CH		;current drive
	mov	dl,curdrive		;current drive val in PSP
	MOV	AH,36H			;get drive specs
	INT	21H
	mov	ax,offset Terminate	;this is Soooo bad...
	push	ax			; .. but I love it!
	mov	al,4			;assume Errorlevel 4
	CMP	DX,0162H		;360Kb?
	JNZ	Chk320			; Nope
	 MOV	DX,OFFSET K360Msg	;'360K disk'
;	 jmp	short Terminate
	 ret				;to Terminate

Chk320:	dec	al			;assume Errorlevel 3
	CMP	DX,013BH		;320Kb?
	JNZ	Chk180			; nope
	 MOV	DX,OFFSET K320Msg	;'320K disk'
;	 jmp	short Terminate
	 ret				;to Terminate

Chk180:	dec	al			;assume Errorlevel 2
	CMP	DX,015FH		;180Kb?
	JNZ	Chk160			; Nope
	 MOV	DX,OFFSET K180Msg	;'180K disk'
;	 jmp	short Terminate
	 ret				;to Terminate

Chk160:	dec	al			;assume Errorlevel 1
	CMP	DX,0139H		;160Kb?
	JNZ	Unknown			; nope
	 MOV	DX,OFFSET K160Msg	;'160K disk'
;	 jmp	short Terminate
	 ret				;to Terminate
Unknown:
	xor	al,al			;return Errorlevel 0
	MOV	DX,OFFSET UnkMsg	;'Unrecognized..'
	pop	bx			;clear the pushed return address

Terminate:
	mov	bx,ax			;save Errorlevel (AL) in bx
	call	Display			;CrLf, string in DX, CrLf
	mov	ax,bx			;restore AL Errorlevel
	MOV	AH,4CH			;terminate process
	INT	21H			;exit

Die:	call	Display			;CrLf, string in DX, CrLf
	INT	20H			;program terminate

Display:
	mov	di,dx			;save string offset
	mov	dx,offset CrLf
	mov	si,dx			;save CrLf offset
	mov	ah,9			;display string
	int	21H
	mov	dx,di			;restore string offset
	int	21H			;AH is still 9
	mov	dx,si			;restore CrLf offset
	int	21H			;do terminating CrLf
	int	21H			;wants 2 of them
	ret

K360Msg	DB	'360K disk$'

K180Msg	DB	'180K disk$'

K320Msg	DB	'320K disk$'

K160Msg	DB	'160K disk$'

UnkMsg		DB	7,'Unrecognized disk format$'

BadDrvMsg	DB	7,'Invalid drive specifier!$'

Dos2Msg		db	7,'This utility only works with '
		db	'DOS 2.0 or higher!$'

CrLf		db	CR,LF,'$'
Dsize	endp

	CodeSeg	ENDS
	END	Dsize
