TITLE	TIMEREAD	1-10-85	[4-18-88]
;Toad Hall Disassembly, tweak

;Wait for user input (Y or N) in a timeout loop.
;Return Errorlevel =
; 0 = No
; 1 = Yes
; 2 = Timed out (no response)

LF	EQU	0AH
CR	EQU	0DH
;
;INITIAL VALUES :	CS:IP	0000:0100
;			SS:SP	0000:FFFF
CodeSeg	SEGMENT
	ASSUME DS:CodeSeg,SS:CodeSeg,CS:CodeSeg,ES:CodeSeg
	ORG	100H

TimeRead	proc	near
	JMP	SHORT	PromptLup

ynStr	DB	' (Y/N) $'
beepStr	DB	7
crlfStr	db	LF,CR,'$'

PromptLup:
	MOV	DX,OFFSET ynStr		;'Y/N'
	mov	ah,9			;display string
	INT	21H
	MOV	CX,0AH			;10 retries

RetryLup:
	call	Chk_Kbd			;check kbd status
	je	Get_Key			; yep, go process it
	xor	ah,ah			;turn on cassette motor?
	INT	15H			;weird ...
	MOV	AH,2			;display char
	MOV	DL,'.'
	INT	21H
	call	Delay			;delay a bit
	call	Chk_Kbd			;check kbd status
	je	Get_Key			; yep
	MOV	AH,1			;turn off cassette motor
	INT	15H			; weird ...
	call	Delay			;delay a bit
	LOOP	RetryLup		;retry loop

	MOV	AL,2			;timed out, return Errorlevel = 2
	JMP	SHORT	Endit		; and terminate

Get_Key:
	MOV	AH,1			;kbd input w/echo
	INT	21H
	and	al,5FH			;uppercase it
	CMP	AL,'Y'
	JZ	Said_Yes
;	CMP	AL,'y'
;	JZ	Said_Yes
	CMP	AL,'N'
	JZ	Said_No
;	CMP	AL,'n'
;	JZ	Said_No
	MOV	DX,OFFSET beepStr	;Bell, newline
	MOV	AH,9			;display string
	INT	21H
	JMP	SHORT	PromptLup	;reloop

Said_Yes:
	MOV	AL,1			;yes, return Errorlevel = 1
	JMP	SHORT	Endit

Said_No:
	xor	al,al			;no, return Errorlevel = 0
Endit:
	mov	bx,ax			;save Errorlevel in AL
	mov	dx,offset crlfStr	;newline
	mov	ah,9			;display string
	int	21H
	mov	ax,bx			;restore Errorlevel in AL
	MOV	AH,4CH			;terminate process
	INT	21H
TimeRead	endp


;Common procedure (used twice) .. check kbd status,
;return zflag if char ready
Chk_Kbd	proc	near
	MOV	AH,0BH			;check kbd status
	INT	21H
	CMP	AL,0FFH			;anything there?
	ret				;with ZFlag set accordingly
Chk_Kbd	endp


;Common procedure (used twice) .. delay a while
Delay	proc	near
	MOV	BX,0F100H		;delay counter
DelayLup:
	nop
	dec	bx
	jne	DelayLup		;delay loop
	ret
Delay	endp

CodeSeg	ENDS
	END	TimeRead
