TITLE	WAITUNTL	12-7-84	[4-19-88]
;Toad Hall Disassembly, tweak

LF	EQU	0AH
CR	EQU	0DH
;
;INITIAL VALUES :	CS:IP	0000:0100
;			SS:SP	0000:FFFF
CodeSeg	SEGMENT
	ASSUME DS:CodeSeg,SS:CodeSeg,CS:CodeSeg,ES:CodeSeg

	ORG	80H
cmdlen	db	?,?		;cmd line length byte at 80H
hrdgt	dw	?		;"23" hour digits at 82H
hr_sep	db	?		;":" separator at 84H
mindgt	dw	?		;"59" minute digits at 85H
min_sep	db	?		;":" separator at 87H
secdgt	dw	?		;seconds digits at 88H

bogus	db	8 dup(?)	;assume CR, 0 here (just a filler)

;Toad Hall:  We're gonna use the PSP for our working data space
; (just showing off how to really scrimp on code space!)

tgtHr		db	?
tgtMin		db	?
tgtSec		db	?
currentSec	db	?
cursorPsn	dw	?

	ORG	100H

WaitUntl	proc	near
;	JMP	SHORT	Start
;
;	DB	8,8,'  ',CR,LF
;	DB	'*** WAIT.COM ***'
;	db	LF,CR,'(c)1983 by Software Research',LF
;	DB	1AH			;in case anyone TYPEs this...

;Start:
	cmp	cmdlen, 9		;9 chars on PSP cmd line?
	JZ	Chk_Parms		; yep, ok so far

Die:	JMP	BadParm_Exit

Chk_Parms:
	cmp	hr_sep,':'		;hour/minute separator there?
	JNZ	Die			; nope, bad parm, exit
	cmp	min_sep,':'		;minute/second separator there?
	JNZ	Die			; nope, bad parm, exit
	mov	ax,hrdgt		;get hour digits
	CALL	Conv_Int		;process
	CMP	AL,17H			;>2300?
	JA	Die			; yep, bad parm, exit
	MOV	tgtHr,AL		; ok, save as hours
	mov	ax,mindgt		;get minute digits
	CALL	Conv_Int		;process
	CMP	AL,3BH			;> 59 minutes?
	JA	Die			; yep, bad parm, exit
	MOV	tgtMin,AL		; ok, save as minutes
	mov	ax,secdgt		;get second digits
	CALL	Conv_Int		;process
	CMP	AL,3BH			;> 59 seconds?
	JA	Die			; yep, bad parm, exit
	MOV	tgtSec,AL		; ok, save as seconds

	MOV	DX,OFFSET timeStr	;'Time '
	MOV	AH,9			;display string
	INT	21H
	xor	bh,bh			;video page 0
	MOV	AH,3			;read cursor psn
	INT	10H
	MOV	cursorPsn,DX		;save cursor psn for digit repsn
Check_Time:
	MOV	AH,2CH			;get DOS system time
	INT	21H
	CMP	DH,currentSec		;seconds = the last second?
	JZ	Check_Time		; yep, haven't even ticked yet
	MOV	currentSec,DH		;save seconds
	mov	di,dx			;save sec/decisecs
	MOV	AH,2			;set cursor psn
	MOV	DX,cursorPsn		;saved cursor location
	xor	bh,bh			;video page 0
	INT	10H
	mov	dx,di			;restore sec/decisecs
	MOV	AL,CH			;get hours
	CALL	WordOut			;process
	MOV	AL,':'			;separator
	CALL	CharOut			;display
	MOV	AL,CL			;get minutes
	CALL	WordOut			;display
	MOV	AL,':'			;separator
	CALL	CharOut			;display
	MOV	AL,DH			;get seconds
	CALL	WordOut			;display
	CMP	CH,tgtHr		;hours = target hrs?
	JNZ	Check_Time		; nope
	CMP	CL,tgtMin		;minutes = target minutes?
	JNZ	Check_Time		; nope
	CMP	DH,tgtSec		;seconds = target seconds?
	JNZ	Check_Time		; nope
	mov	ax,4C00H		;Errorlevel = 0
	int	21H			;terminate

BadParm_Exit:
	MOV	DX,OFFSET invalParmStr	;'Invalid parm'
	MOV	AH,9			;display string
	INT	21H
	mov	ax,4C01H		;Errorlevel = 1
	int	21H			;terminate
WaitUntl	endp

Conv_Int	proc	near
	XCHG	AL,AH			;swap
	AND	AX,0F0FH		;mask
	AAD				;convert
	RET
Conv_Int	endp


WordOut	proc	near
	AAM				;convert to base 10
	XCHG	AL,AH			;swap
	OR	AX,3030H		;asciify the word
	CALL	CharOut
	MOV	AL,AH
CharOut:
	MOV	DL,AL			;char into DL
	PUSH	AX			;save word
	MOV	AH,2			;display char
	INT	21H
	POP	AX			;restore word
	RET
WordOut	endp

;A bogus process, just to keep MASM happy
DataStuf	proc	near

invalParmStr	DB	'Invalid Parameter [HH:MM:SS]',LF,'$'

timeStr	DB	'  Time $'

;tgtHr	DB	0
;tgtMin	DB	0
;tgtSec	DB	0
;currentSec	DB	0
;cursorPsn	dw	0

DataStuf	endp

CodeSeg	ENDS
	END	WaitUntl
