	  PAGE	 80,132
	  TITLE  Y-N  -  Ask Y/N in Batch File
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
; * Y-N 								  *
; * Displays command line and then accepts a Y or N, setting ERRORLEVEL   *
; * to 1 or 0 respectively.  Used only from BATch files.		  *
; * Written by: 							  *
; * R. Lehr, 901 Rye Beach Rd., Huron Ohio  44839			  *
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
; Conversion from ? assembler format to IBM MASM 2.0 format, and trivial  *
; bug fixes.  8-18-87 Alan Cox						  *
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
PROG      SEGMENT BYTE PUBLIC 'PROG'
	  ASSUME  CS:PROG
	  ASSUME  DS:PROG
	  ORG	 100H
MAIN	  PROC	 NEAR
	  JMP	 START

;* * * * *
;*  data *
;* * * * *
CHAROUT  db  ?
         db  10,13,'$'
EXITCODE db  ?
CMDLN	 db  127 dup(?)
         db  '$'

;* * * * *
;*  code *
;* * * * *
START:
;----- Copy command line -----
       mov  ax,129	; command line at offset 129 int PSP
       mov  si,ax	; (Program Segment Prefix)
       xor  cx,cx
       mov  cl,ds:[128] 	       ;Length of command line at offset 128
       lea  DI,CMDLN
       cmp  cx,00	; if command line length > 0 then
       je   LNEND
       inc  si		;    skip blank in command line
       dec  cx		;    and adjust length accordingly
       rep  movsb
       mov  [di], byte ptr ' ' ; append 1 blank
       inc  di
LNEND: mov  [di], byte ptr '$' ; append string terminator

;----- Display command line -----
       mov  AH,09	; display command line
       lea  DX,CMDLN
       int  21h

;----- Accept Y or N -----
GETYN: nop		; repeat
       mov  AH,08	;    accept keyboard input into AL (no echo)
       int  21h
       cmp  AL,00	;    if chr(0) not ASCII
       jne  UP
       int  21h 	;    get and discard scan code
       jmp  ENDGETYN
UP:
       and  AL,0DFh	;    convert to upper case
Y:
       cmp  AL,'Y'      ;    if Y
       jne  N
       call DISPLAY	;	display it
       mov  EXITCODE,1	;	exitcode = 1
       jmp  RETURN
N:
       cmp  AL,'N'      ;    else if N
       jne  ENDGETYN
       call DISPLAY	;	display it
       mov  EXITCODE,0	;	exitcode = 1
       jmp  RETURN
ENDGETYN:
       jmp  GETYN	; until Y or N

RETURN:
       mov  ah,04Ch	; return with ERRORLEVEL in AL
       mov  al,EXITCODE
       int  21h

	  MAIN	 ENDP

;* * * * * * * *
;*  procedures *
;* * * * * * * *
DISPLAY proc
	mov CHAROUT,AL	; display Y or N and <cr><lf>
	mov AH,09	;
	lea DX,CHAROUT
	int 21h
	ret
DISPLAY endp
PROG	  ENDS
	  END	 MAIN
