/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <stdlib.h>
#include <string.h>
#include <dos.h>


/***
 *
 *  Function   :    gettmppath
 *
 *  Topics     :    Transforms a filename into a full pathname
 *                  relative to temporary directory.
 *
 *  Decisions   :  Temporary directory is first searched
 *                 into environment variable 'TEMP',
 *                 after into environment variable 'TMP'.
 *                 If none are defined, 'C:\' is assumed.
 *
 *  Parameters :    in/out  char *filename    filename
 *
 *  Return     :    pointer to filename
 *
 ***/

char *gettmppath( char *filename )
{
 char *ptr;

 ptr = getenv( "TEMP" );
 if ( ! ptr || ! *ptr ) ptr = getenv( "temp" );
 if ( ! ptr || ! *ptr ) ptr = getenv( "TMP" );
 if ( ! ptr || ! *ptr ) ptr = getenv( "tmp" );

 if ( ! ptr || ! *ptr ) putenv( "TEMP=C:\\" );

 {
  char buffer[_MAX_PATH];
  strcpy( buffer, filename );
  _makepath( filename, "", ptr, buffer, "");
  fnreduce( filename );
 }

 if ( ! ptr || ! *ptr ) putenv( "TEMP=" );

 return filename;
}


#ifdef MAIN

#include <stdio.h>
#include <conio.h>
void main( void )

{
 char f[_MAX_PATH];

 strcpy( f, "abc.ext" );

 putenv( "TEMP=e:\\tmp" );
 putenv( "TMP=c:\\tmp" );
 clrscr();
 printf( "%s\n", gettmppath(f) );
 getch();
}

#endif
