/* cpio: copy input to output */

#define  BUFSIZE  512	   /* best size for IBM PC/XT/AT */
#define  CMASK	  '\377'   /* for making char's > 0 */

main()
{
      char  buf[BUFSIZE];
      int   n;

      while ((n = read(0, buf, BUFSIZE)) > 0)
	 write(1, buf, n);
      exit(0);
}


getchars()  /* unbuffered single character input */
{
      char  c;

      return((read(0, &c, 1) > 0) ? c & CMASK : EOF);
}


getcharb()  /* buffered version */
{
      static   char  buf[BUFSIZE];
      static   char  *bufp = buf;
      static   int   n = 0;

      if (n == 0) {  /* buffer is empty */
	 n = read(0, buf, BUFSIZE);
	 bufp = buf;
      }
      return((-n >= 0) ? *bufp++ & CMASK : EOF);
}




