	PAGE	55,132
	NAME	f_init
	TITLE	FOSSIL Interface Routines for Microsoft C and Turbo C
	SUBTTL	Copyright 1988 Marshall Presnell; All Rights Reserved

;************************************************************************; 
;*									*; 
;*	    Assembled with Microsoft Macro Assembler version 5		*; 
;*	       using MIXED.MAC mixed language macro package.		*; 
;*									*; 
;************************************************************************; 

;========================================================================; 
;=----------------------------------------------------------------------=; 
;=-                                                                    -=; 
;=-	      THIS MODULE HAS BEEN RELEASED FOR USE IN C NEWS	       -=; 
;=-			      					       -=; 
;=-    	ANY QUESTIONS, COMMENTS, OR PROBLEMS SHOULD BE ADDRESSED TO    -=; 
;=-			      					       -=; 
;=-			     MARSHALL PRESNELL			       -=; 
;=-			     13652 LYNN STREET			       -=; 
;=-			   WOODBRIDGE, VA  22191		       -=; 
;=-			      					       -=; 
;=-			FIDONET ADDRESS 109/639.106		       -=; 
;=-								       -=; 
;=----------------------------------------------------------------------=; 
;========================================================================; 

	.8086
	INCLUDE	MIXED.MAC
	SETMODEL

	.CODE

;==========================================================================;
;									   ;
;		SYSTEM EQUATES FOR FOSSIL VERSION 5 INTERFACE		   ;
;									   ;
;==========================================================================;

SETBAUD		EQU	00H
TXCHAR		EQU	01H
RXCHAR		EQU	02H
STATUS		EQU	03H
INIT		EQU	04H
DEINIT		EQU	05H
DTR		EQU	06H
TTICK		EQU	07H
OUTFLUSH	EQU	08H
OUTPURGE	EQU	09H
INPURGE		EQU	0AH
TXNOWAIT	EQU	0BH
PEEK		EQU	0CH
KEYREADNOWAIT	EQU	0DH
KEYREAD		EQU	0EH
FLOWCONTROL	EQU	0FH
CONTROL_C_CHECK	EQU	10H
SETCURS		EQU	11H
GETCURS		EQU	12H
WRANSI		EQU	13H
WATCHDOG	EQU	14H
WRBIOS		EQU	15H
TTICK_FUNCTION	EQU	16H
REBOOT		EQU	17H
READBLOCK	EQU	18H
WRITEBLOCK	EQU	19H
BREAK		EQU	1AH
DATASTRUCTURE	EQU	1BH
INSTALLAPI	EQU	7EH
REMOVEAPI	EQU	7FH

;===========================================================================
;
;	int f_init(int port, int trigger, int * flag_address)
;

HPROC	<f_init>,<USES BX, CX, DX>,PORT:WORD,TRIGGER:WORD,FLAG_ADR:PTR

	PUSH	ES			;Save ES on stack (SP+2)
	MOV	AX, CS			;Establish code segment visibility
	MOV	ES, AX			;in ES register

	PLES	CX, FLAG_ADR		;Flag address to ES:CX
	MOV	BX, 0			;Clear the "magic" number out of BX

	MOV	AX,TRIGGER		;Check Trigger Word for non-zero
	XOR	AX,AX			;Set the flags for comparison
	JZ	NOFLAG			;If zero, no trigger

	MOV	BX, 4F50H		;Otherwise, Load magic number to BX

NOFLAG:	MOV	DX, PORT		;Load Port address to DX
	MOV	AH, INIT		;Load Function code to AH
	INT	14H			;Call FOSSIL

	POP	ES			;Restore ES (SP+0)
	HRET				;Return AX to caller

HENDP	f_init

	END

