#include <conio.h>
#include <stdio.h>
#include "gccint8.h"

void            header(void);

void            main(void)
{
    int             i;
    unsigned long int tick_1,
                    tick_2,
                    elapsedtime;

    header();

    ScreenSetCursor(2, 0);
    puts("Initialize PCTIMER: init8h(1000). Start millisecond precision timing routine.");
    puts("Press any key to continue.");
    getkey();

    init8h(1000);
    ticks_8h = 0;

    ScreenSetCursor(6, 0);
    puts("Test delay8h(2000). Delay 2000 milliseconds (2 seconds).");
    puts("Press any key to begin.");
    getkey();

    tick_1 = ticks_8h;
    delay8h(2000);
    tick_2 = ticks_8h;

    ScreenSetCursor(9, 0);
    printf("int8h ticks=%u\n", (tick_2 - tick_1));
    elapsedtime = time8h(tick_1, tick_2);
    printf("int8h ms=%u\n", elapsedtime);

    ScreenSetCursor(12, 0);
    puts("Test sound8h(800, 300). Generate a 800 Hz sound for 300 ms.");
    puts("Press any key to begin.");
    getkey();

    sound8h(800, 300);

    puts("\nPress any key to continue.");
    getkey();

    header();

    ScreenSetCursor(2, 0);
    puts("Five trials of measuring reaction times.");
    puts("Press any key to begin.");
    getkey();

    header();

    ScreenSetCursor(1, 0);
    for (i = 0; i < 5; i++) {
        tick_1 = ticks_8h;
        puts("\nPress any key to stop timer.");
        getkey();
        tick_2 = ticks_8h;
        printf("int8h ticks=%u\n", (tick_2 - tick_1));
        elapsedtime = time8h(tick_1, tick_2);
        printf("int8h ms=%u\n", elapsedtime);
    }

    getkey();
    header();
    ScreenSetCursor(2, 0);
    puts("Quit PCTIMER: quit8h(). Quit millisecond precision timing routine.");
    puts("Press any key to quit.");
    getkey();

    quit8h();

    ScreenClear();
    ScreenSetCursor(0, 0);
}

void            header(void)
{
    ScreenClear();
    ScreenSetCursor(0, 0);
    puts("PCTIMER 1.2 Demonstration Program");
    ScreenSetCursor(1, 0);
    puts("--------------------------------------------------------------------------------");
    ScreenSetCursor(22, 0);
    puts("--------------------------------------------------------------------------------");
}
