/*****************************************************************************
   MODULE: rgetf.c
  PURPOSE: recio character delimited floating point input functions
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.12
  RELEASE: January 29, 1995
*****************************************************************************/

#include <ctype.h>
#include <errno.h>
#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern char *_rfldstr(REC *rp, size_t len);
extern char *_rerrs(REC *rp, int errnum);

/****************************************************************************/
static double                /* return floating point value                 */
    _rgetd(                  /* get floating point number from rec stream   */
        REC *rp,             /* pointer to record stream                    */
        double negmin,       /* valid negative minimum value                */
        double negmax,       /* valid negative maximum value                */
        double posmin,       /* valid positive minimum value                */
        double posmax)       /* valid positive maximum value                */
/****************************************************************************/
{
    double result=0.0;       /* result to return */
    double val;              /* conversion value */
    char *fldptr;            /* pointer to field string */
    char *endptr;            /* pointer to first invalid field char */

    if (_risready(rp, R_READ)) { 
      fldptr = _rfldstr(rp, 0); 
      if (fldptr) {
        strims(fldptr);
        for (;;) { 
          if (*fldptr != '\0') { 
            endptr = fldptr; 
            errno = 0; 
            val = strtod(fldptr, &endptr); 
            while (isspace(*endptr)) endptr++; 
            if (errno==ERANGE || !*endptr) { 
              if (!errno) { 
                if (!val || (val >= negmin && val <= negmax) || 
                            (val >= posmin && val <= posmax)) { 
                  result = val; 
                  goto done; 
                } 
              } /* data out of range */ 
              fldptr = _rerrs(rp, R_ERANGE); 
              if (fldptr) { continue; } else { goto done; } 
            } /* invalid data */ 
            fldptr = _rerrs(rp, R_EINVDAT); 
            if (fldptr) { continue; } else { goto done; } 
          } /* missing data */ 
          fldptr = _rerrs(rp, R_EMISDAT); 
          if (fldptr) { continue; } else { goto done; } 
        } 
      }
    } 
done: 
    return result; 
}

/****************************************************************************/
/* character delimited floating point input functions                       */
/****************************************************************************/
float rgetf(REC *rp)
{
    return (float) _rgetd(rp, -FLT_MAX, -FLT_MIN, FLT_MIN, FLT_MAX);
}

double rgetd(REC *rp)
{
    return _rgetd(rp, -DBL_MAX, -DBL_MIN, DBL_MIN, DBL_MAX);
}
