/*****************************************************************************
   MODULE: rwmsg.c
  PURPOSE: recio simple warning message function
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.13
  RELEASE: September 4, 1995
*****************************************************************************/

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

/****************************************************************************/
void                         /* returns nothing                             */
    rwarnmsg(                /* recio simple callback warning function      */
        REC *rp)             /* record pointer                              */
/****************************************************************************/
{
  if (risvalid(rp)) {
    rsetfldch(recerr, ' ');
    rsettxtch(recerr, ' ');

    switch (rwarning(rp)) {
    case R_WWIDTH:  /* data too wide to fit into columnar output */
    case R_WEMPSTR: /* empty data string */
    case R_WTMFMT:  /* time data incomplete */
      rputs(recerr, "\nWARNING in");
      rputs(recerr, rnames(rp));
      rputs(recerr, "at record");
      rputul(recerr, rrecno(rp));
      rputs(recerr, "and field");
      rputui(recerr, rfldno(rp));
      rputs(recerr, "--");
      rputs(recerr, rwarnstr(rp));
      rputrec(recerr);
      break;
    case R_WNOREG:  /* atexit() full */
    default:        /* unknown warning */
      rputs(recerr, "\nWARNING --");
      rputs(recerr, rwarnstr(rp));
      rputrec(recerr);
      break;
    }
  }
}
