/*
**  DOW.C
**
**  Public domain by VinhHao Nguyen, 03/94
*/

#ifdef ISO      /* monday == 0 */
 #define ADJ 5
#else           /* sunday == 0 */
 #define ADJ 6
#endif

unsigned dow(unsigned y, unsigned m, unsigned d)
{
      if (m < 3)
      {
            m += 13;
            y--;
      }
      else  m++;
      return (d + 26 * m / 10 + y + y / 4 - y / 100 + y / 400 + ADJ) % 7;
}

#ifdef TEST

#include <stdio.h>

main(int argc, char *argv[])
{
      void usage(void);
      unsigned d, m, y, days[] = {31, 29, 31, 30, 31, 30,
                                  31, 31, 30, 31, 30, 31};
      char *day[]   = {"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun",};
      char *month[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                       "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",};
      

      if (4 > argc)
            usage();
      y = atoi(argv[1]);
      m = atoi(argv[2]);
      d = atoi(argv[3]);
      if (!m || m > 12)
            usage();
      if (!d || d > days[m - 1])
            usage();
      if (y < 100)
            y += 1900;
      printf("%d %s %d is a %s\n", d, month[m - 1], y,
            day[dow(y, m, d) - 1]);
      return 0;
}

void usage(void)
{
      puts("Usage: DOW yy[yy] mm dd");
      exit(-1);
}

#endif
