// File from page 132 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: NESTFRND.CPP -- Nested friends
#include <stdio.h>
#include <string.h> // memset()
#define SZ 20

struct holder {
private:
  int a[SZ];
public:
  void initialize();
  struct pointer {
  private:
    holder* h;
    int* p;
  public:
    void initialize(holder* H);
    // Move around in the array:
    void next();
    void previous();
    void top();
    void end();
    // Access values:
    int read();
    void set(int i);
  };
  friend holder::pointer;
};

void holder::initialize() {
 memset(a, 0, SZ * sizeof(int));
}

void holder::pointer::initialize(holder* H) {
  h = H;
  p = h->a;
}

void holder::pointer::next() {
  if(p < &(h->a[SZ - 1])) p++;
}

void holder::pointer::previous() {
  if(p > &(h->a[0])) p--;
}

void holder::pointer::top() {
  p = &(h->a[0]);
}

void holder::pointer::end() {
  p = &(h->a[SZ - 1]);
}

int holder::pointer::read() {
  return *p;
}

void holder::pointer::set(int i) {
  *p = i;
}

main() {
  holder h;
  holder::pointer hp, hp2;
  int i;

  h.initialize();
  hp.initialize(&h);
  hp2.initialize(&h);
  for(i = 0; i < SZ; i++) {
    hp.set(i);
    hp.next();
  }
  hp.top();
  hp2.end();
  for(i = 0; i < SZ; i++) {
    printf("hp = %d, hp2 = %d\n",
           hp.read(), hp2.read());
    hp.next();
    hp2.previous();
  }
}
