#include "bl.h"

Bl::Bl(rect coord, char* fName, char* h, int shadow, int res,
            BORDERS b_type, BORDERS hdr_b_type, int pat, int hdr_pat,
	    int elem_pat)
    {
    w1 = new Window(coord, fName, h, shadow, b_type, hdr_b_type,
	       res, pat, hdr_pat);
    background(w1);

    rect r;
    cancel_element = new Element(
        (r = rect(screenXL(coord.origin.X) + w1->get_shadow(),
	     screenYT(coord.origin.Y) + w1->get_shadow(),
	     screenXR(coord.origin.X + 2) + w1->get_shadow(),
	     screenYB(coord.origin.Y + 1) + w1->get_shadow())),
	     CANCEL_ELEMENT, BUTTON_BORDER, elem_pat, 1);

    cancel_element->set_ret(1);

    add(cancel_element);
    assign(w1, cancel_element, AC_CANCEL);

    if(res & MOVE)
	{
	move_element = new Element(
	    rect(r.origin.X, r.origin.Y + pScreenSet->cell_height,
	    r.corner.X, r.corner.Y + pScreenSet->cell_height),
	    MOVE_ELEMENT, BUTTON_BORDER, elem_pat, 1);
	add(move_element);
	assign(w1, move_element, AC_MOVE);
        }
    else
        move_element = NULL;
    if(res & RESIZE)
        {
	resize_element = new Element(
	    rect(screenXL(coord.origin.X) + w1->get_shadow(),
	         screenYT(coord.origin.Y + 2) + w1->get_shadow(),
		 screenXR(coord.origin.X + 2) + w1->get_shadow(),
		 screenYB(coord.origin.Y + 3) + w1->get_shadow()),
		 RESIZE_ELEMENT, BUTTON_BORDER, elem_pat, 1);
	add(resize_element);
	assign(w1, resize_element, AC_RESIZE);
        }
    else
        resize_element = NULL;

    moveTo(1);
    }
////////////////////////
void Bl::rearrange()
    {
    rect coord = textRect(w1->bound());
    rect r;
    cancel_element->repose(r =
        rect(screenXL(coord.origin.X) + w1->get_shadow(),
	     screenYT(coord.origin.Y) + w1->get_shadow(),
	     screenXR(coord.origin.X + 2) + w1->get_shadow(),
	     screenYB(coord.origin.Y + 1) + w1->get_shadow()));

    if(move_element != NULL)
	move_element->repose(
	    rect(r.origin.X, r.origin.Y + pScreenSet->cell_height,
	    r.corner.X, r.corner.Y + pScreenSet->cell_height));
    if(resize_element != NULL)
	resize_element->repose(
            rect(screenXL(coord.origin.X) + w1->get_shadow(),
	         screenYT(coord.origin.Y + 2) + w1->get_shadow(),
		 screenXR(coord.origin.X + 2) + w1->get_shadow(),
		 screenYB(coord.origin.Y + 3) + w1->get_shadow()));
    }
////////////////////////
void Bl::show_window()
    {
    mouseHideCursor();
    w1->show_window();
    show();
    mouseShowCursor();
    }
////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    Bl b(rect(10, 10, 60, 20), "window.pcy", "Block", 6,
	    MOVE | RESIZE, SHOW_BORDER, SHOW_BORDER,
	    16, 17, 18);

    b.show_window();
    b.exe();

    close_KNOW_HOW();
    closegraph();
    }
*/
