#ifndef __RESTRICT_EDIT_H_
#define __RESTRICT_EDIT_H_

#include "edwin.h"

class RestrictEdit : public EditWindow
    {
    protected:
	int maxStringLen;       // maximum total bytes
	int maxLines;           // maximum lines in string
	int maxLineLen;         // maximum length of individual line

    public:
	RestrictEdit(rect coordinates,
		  int s_len, int l_len, int n_lines,
		  char* fName = "", char* h = "",
		  int s = 6, int b_type = 1, int res = FIXED,
		  char* font = "hv08a.sfp", char* swaper = "work.swp",
		  const char* str = "", loc sc = loc(1, 1),
		  int interv = 15)
	     : EditWindow(coordinates, fName, h, s, b_type, res,
		  font, swaper, str, loc(1, 1), rect(0, 0, 0, 0),
		  sc, interv, HORIZ_DIR)
	      {
	      maxStringLen = s_len;
	      maxLines = n_lines;
	      maxLineLen = l_len;
	      }

	int printableChar(int key);

    };

#endif __RESTRICT_EDIT_H_