/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tststr.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Test program for the string class.
*
* $Id: tststr.cpp 1.1 1994/03/09 12:19:55 kjb release $
*
****************************************************************************/

#include "str.hpp"
#include <alloc.h>
#include <new.h>
#include <stdlib.h>

void new_handler(void)
{
	cerr << "Out of memory!\n";
	exit(1);
}

void test(void)
{
	DynStr	s1,s2("This is a test"),s3('-',14);

	cout << s2 << endl << s3 << endl;
	cout << s2.hash() << endl;

	cout << (s1 = "test this is a (yeah sure)") << endl;
	s1.toupper();
	cout << s1 << endl;

	s1 = "/*--*\\";
	cout << (s1 *= 5) << endl;
	s1 = "Copyright (C) 1994 SciTech Software";

	uint SIZE = 70;
	s2 = s1;
	cout << '|' << DynStr('-',SIZE) << '|' << endl;
	cout << '|' << s1.justify(DynStr::left,SIZE,true) << '|' << endl;
	s1 = s2;
	cout << '|' << s1.justify(DynStr::center,SIZE,true) << '|' << endl;
	s1 = s2;
	cout << '|' << s1.justify(DynStr::right,SIZE,true) << '|' << endl;

	SubStr	*array;
	uint	count;

	s1 = "This is a test of nothing";
	s1 = "d:\\bc\\src\\classlib\\objbased\\fuckyou.c";
	count = s1.split(array,"\\");

	for (int i = 0; i < count; i++)
		cout << "   " << array[i] << endl;
}

void main(void)
{
	set_new_handler(new_handler);

	cout << "\nMemory at start: " << (unsigned long)coreleft() << endl;

	test();

	cout << "\nMemory at end: " << (unsigned long)coreleft() << endl;
}
