/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 19                        
                                                                            
  This program loads in some sprites created with the WGT Sprite Editor.    
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 Make sure that SPACE.SPR is in your executable directory.                  
                                                                            
ͼ
*/

#include <wgt4.h>

block screen1;		/* one virtual screen */
block sprites[10];	/* An array of blocks to load the sprites into.
			   Version 4.0 allows for any number to be
			   loaded in, as long as you pass the same size
			   of the array to the wloadsprites and wfreesprites
			   commands. */
int y,sp;
int oldmode;
color palette[256];


void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }
  oldmode = wgetmode();
  vga256();
  wloadsprites(palette,"space.spr",sprites,0,9);
  /* loads the first 10 sprites */
  wsetpalette(0,255,palette);

  screen1 = wnewblock(0,0,319,199);
  wsetscreen(screen1);

  sp = 1;	  		/* sprites always start at 1 in the array */
  minit();
  msetbounds(0,0,160,199);

  do {
    for (y = 0; y < 200; y++)
    {
      wsetcolor(y);
      wfline(0,y,319,y); /* clear the screen by drawing horz lines (fast) */
    }

    if (sprites[sp] !=NULL)
     {
      wputblock(mx,my,sprites[sp],1);	/* put the block using xray mode at mouse position */

      wflipblock(sprites[sp],0); /* flip the sprite vertically */
      wresize(mx-20,my+50,mx+20,my+90,sprites[sp],1); 
         /* resize the sprite using xray mode just below the first one */
      wflipblock(sprites[sp],0); /* flip it back to normal */
     }
    wcopyscreen(0,0,160,199,screen1,0,0,NULL);  /* copy the whole screen */

    if (but == 1)  /* Show the next sprite */
    {
      sp++;
      if (sp > 9) sp=1;
      noclick();
    }

  } while (but !=2);		/* right button exits */
  msetbounds(0,0,319,199);
  mdeinit ();                   /* Deinitialize the mouse handler */
  wfreeblock(screen1);
  wfreesprites(sprites,0,9);  /* frees all sprites in that array */
  wsetmode(oldmode);
}