/* ---------------------------------------------------------------------
 *	contour.h
 *	
 *	defines the leaf structure and does the usual includes
 * --------------------------------------------------------------------- */

#include <WindowMgr.h>

typedef struct {
	union {
		long key;	  	/* key = h,v concatenated */
		Point p;
	} header;
	int  curve;   	/* curve that this point is on */
} LEAF;

#define HBITMAX 576	/* max pixels in horiz direction */
#define VBITMAX 720 /* max pixels in vert direction */

#include "tree.h"

typedef struct curve_data {
	Point 	p;						/* starting point of curve */
	int		parent;					/* parent (enclosing) curve */
	int 	elevation;				/* elevation of the curve */
	int 	searched;				/* has interior been searched? */
} curve_data;
