Code Modules
   The project includes five major code modules.  Three are presented
in Listings 3, 4 and 5.  This modularity provides a high degree of
data hiding between modules by using the static storage class.  Also,
the SEND and RECV modules could be used separately if required.
  The major functions within each module are listed below:
  1. COMMINT:  Includes the interrupt handler with all UART and
     hardware specific references. (Not in Listings)
     a) All references to the infifo (interrupt receive buffer)
     b) Routines to install and remove the interrupt handler
     c) Code to read and write configuration values to the UART
     d) Stores previous UART and interrupt controller environment.
  2. XMUTIL:  Xmodem utility procedures common to send and receive
     (Not in Listings)
     a) read_comm()    Pass the max length to read and a timeout value
     b) close_comm()   Removes the interrupt handler and returns
     c) init_comm()    Installs the interrupt handler and sets up UART
     d) updcrc()       Updates the crc based on a global flag
     e) Declares error messages used by both send and receive machines
     f) A_EatRest()    Gobbles the remainder of bad frames
     g) A_Xfer_End()   Used to post the end msg from a transfer
  3. XMRECV:  All logic to receive a single file using xmodem
     protocol.  Uses high level interface to comm hardware for I/O
     a) A_Prep_Recv()  Prompts for file to receive, opens file
     b) A_Frame_Wait() Sends single ctrl char and awaits response
     c) A_Which_Ctrl() Parses first char of frame
     d) CRC_Good()     Used by A_Validate to compare the CRC/Checksum
     e) A_Validate()   Checks the xmodem hdr and the frame
     f) A_EatRest()    Disposes of the remainder of a bad packet
     g) A_Recv_End()   Used to post the end msg from a transfer
     h) The RECV STATE TABLE drives the above actions based on their
        returned value (events) from the xmrecv() module.
  4. XMSEND:  All logic to send a single file using xmodem protocol.
     Uses high level interface to comm hardware for all I/O.
     a) A_Get_Fname()  Prompts for file to transmit, opens file.
     b) A_Init_Wait()  Waits for initial NAK/CRC flag
     c) A_Wait()       Waits for a single (expected) character
     d) A_Make_Pkt()   Formats the next packet to be sent
     e) A_Send_Pkt()   Posts a packet to the comm port
     f) A_Send_End()   Used to post the end msg from a transfer
     g) The SEND STATE TABLE drives the above actions based on their
        returned value (events) from the xmsend() module.
  5. CTERM1:  Dumb terminal emulator and menu driven user interface
     a) Uses only "high level" interfaces to comm facilities:
        1) init_comm()
        2) read_comm()
        3) write_comm()
        4) Config_Comm()
        5) incomm()
        6) close_comm()
     b) Support routines for safe user input
     c) Accepts command line parameters
     d) Tree structured command menu to the following routines:
        1) Config:  Show current config and prompt for changes.
        2) Dos:     Provide simple access to dos commands via system().
        3) Help:    Simple help listing
        4) Quit:    Remove interrupt handler and exit program
        5) Rcvx:    Receive a file using Xmodem protocol
        6) Sendx:   Send a file using Xmodem protocol
        7) Term:    Go to term mode.
     e) Common ESC key returns to command mode prompt.
