// -------- skeleton.h 

#ifndef SKELETON_H
#define SKELETON_H

#include "baseclas.h"

class Skeleton : public BaseClass	{
	virtual void SetColors();
protected:
public:
	Skeleton(char *ttl, int lf, int tp, int ht, int wd, DFWindow *par)
						: BaseClass(ttl, lf, tp, ht, wd, par)
			{ OpenWindow(); }
	Skeleton(char *ttl, int ht, int wd, DFWindow *par)
						: BaseClass(ttl, ht, wd, par)
			{ OpenWindow(); }
	Skeleton(int lf, int tp, int ht, int wd, DFWindow *par)
						: BaseClass(lf, tp, ht, wd, par)
			{ OpenWindow(); }
	Skeleton(int ht, int wd, DFWindow *par) : BaseClass(ht, wd, par)
			{ OpenWindow(); }
	Skeleton(char *ttl)	: BaseClass(ttl)
			{ OpenWindow(); }
	virtual ~Skeleton()
		{ if (windowstate != CLOSED) CloseWindow(); }
	// -------- API messages
	virtual void OpenWindow();
	virtual void CloseWindow();
};

#endif


// ------------- skeleton.cpp

#include "skeleton.h"

// ----------- common constructor code
void Skeleton::OpenWindow()
{
	if (windowstate == CLOSED)
		BaseClass::OpenWindow();
	SetColors();
	// ..... 
}

void Skeleton::CloseWindow()
{
	// destructor code
	// .....
    BaseClass::CloseWindow();
}

// -------- set the fg/bg colors for the window 
void Skeleton::SetColors()
{
	colors[STD_COLOR][FG] =
	colors[STD_COLOR][BG] =
	colors[SELECT_COLOR][FG] =
	colors[SELECT_COLOR][BG] = BLACK;
	colors[FRAME_COLOR][FG] =
	colors[FRAME_COLOR][BG] =
	colors[HILITE_COLOR][FG] =
	colors[HILITE_COLOR][BG] = LIGHTGRAY;
}




