/*  DATECONV.H
 *  Header file for date functions
 *  Last mod.: 1992-10-10
 */

#define TRUE  1
#define FALSE 0

typedef struct
      {
      int day;
      int month;
      long year;
      long gdn;            /*  gdn and valid are for internal use  */
      int valid;           /*  by functions in this library  */
      } Date;

/*  declarations of functions defined in DATECONV.C  */

void date_to_gdn(Date *dt, char calendar);
void gdn_to_date(Date *dt, char calendar);
long lfloor(long a, long b);
int is_leap_year_c(long year, char calendar);
int is_leap_year(long year);
void set_feb_length(long yr, char calendar);
void reset_feb_length(void);
int day_of_week(long gdn);
