/*  DATETEST.C
 *  Tests date conversion routines
 *  Last mod.: 1992-10-10
 */

/*  Link with DATECONV.OBJ by using
 *  CL DATETEST.C DATECONV.C
 */

#include <STDIO.H>
#include <STDLIB.H>     /*  for exit()  */
#include <CONIO.H>

#include "DATECONV.H"

void main(int argc, char **argv);
void display(long n);
void test(long n, char calendar);

Date date;

#define ESCAPE '\x1B'
#define N 3000
#define MAXIMUM_GDN 2146905911
/*  largest Gregorian day number that can be handled  */

/*-----------------------------*/
void main(int argc, char **argv)
{
long n, m;

if ( argc < 3 )
    {
    printf("Syntax: DATETEST start increment\n");
    return;
    }

n = atol(argv[1]);          /*  number to start with  */
m = atol(argv[2]);          /*  increment  */

printf("Quit with Escape.");

while ( TRUE )
    {
    if ( n%(N*m) == 0 )
        {
        display(n);
        display(-n);
        }
    test(n,'G');
    test(n,'J');
    test(-n,'G');
    test(-n,'J');
    if ( n > MAXIMUM_GDN-m )
        {
        printf("\ngdn = %ld",n);
        return; /*  since next n is too large  */
        }
    n += m;
    if ( kbhit() )
        {
        if ( getch() == ESCAPE )
            break;
        }
    }
}

/*----------------*/
void display(long n)
{
date.gdn = n;
printf("\ngdn =%12ld",n);
gdn_to_date(&date,'G');
printf("   %02d/%02d/%ld (G)",date.month,date.day,date.year);
gdn_to_date(&date,'J');
printf("   %02d/%02d/%ld (J)",date.month,date.day,date.year);
}

/*-------------*/
void test(long n,
          char calendar)
{
date.gdn = n;
gdn_to_date(&date,calendar);
if ( !date.valid )
    {
    printf("\ngdn = %ld  %d/%d/%ld (%c)  Date invalid!",
        date.gdn,date.month,date.day,date.year,calendar);
    exit(1);
    }
date.gdn = 0L;
date_to_gdn(&date,calendar);
if ( date.gdn != n )
    {
    printf("\ngdn = %ld  %d/%d/%ld (%c)   n = %ld!",
        date.gdn,date.month,date.day,date.year,calendar,n);
    exit(1);
    }
}

