// ---------- menus.cpp

#include "dflatpp.h"
#include "testappl.h"

MenuSelection
	PushButtonCommand  ("~Push button",  APWND::BuildPushButton),
	CheckBoxCommand    ("~Check box",    APWND::BuildCheckBox),
	RadioButtonCommand ("~Radio button", APWND::BuildRadioButton);

// ---------- cascaded button menu
MenuSelection *Button[] = {
	&PushButtonCommand,
	&CheckBoxCommand,
	&RadioButtonCommand,
	&SelectionTerminator
};

MenuSelection
	NewCommand     ("~New" ),
	OpenCommand    ("~Open" ),
	PrintCommand   ("~Print", NULLFUNC, 0, False),
	SetupCommand   ("Print ~Setup"),
	ExitCommand    ("E~xit      [Alt+F4]", APWND::Exit, ALT_F4);

MenuSelection
	UndoCommand  ( "~Undo",      NULLFUNC, CTRL_U),
	CutCommand   ( "Cu~t",       NULLFUNC, CTRL_C),
	CopyCommand  ( "~Copy",      NULLFUNC, CTRL_V),
	PasteCommand ( "~Paste",     NULLFUNC, CTRL_X),
	ClearCommand ( "Cl~ear"),
	DelCommand   ( "~Delete",    NULLFUNC, DEL),
	ParaCommand  ( "Pa~ragraph", NULLFUNC, CTRL_P);

MenuSelection
	InsertCommand   ("~Insert    [Ins]", APWND::BuildInsertMode, On, INS ),
	WordWrapCommand ("~Word wrap", NULLFUNC, On );
			   
MenuSelection
	TextBoxCommand ("~Textbox", APWND::BuildTextBox ),
	ListBoxCommand ("~Listbox", APWND::BuildListBox ),
	EditBoxCommand ("~Editbox", APWND::BuildEditBox ),
	ButtonCommand  ("~Buttons", Button );

MenuSelection *File[] = {
	&NewCommand,
	&OpenCommand,
	&SelectionSeparator,
	&PrintCommand,
	&SetupCommand,
	&SelectionSeparator,
	&ExitCommand,
	&SelectionTerminator
};

MenuSelection *Edit[] = {
    &UndoCommand,
	&SelectionSeparator,
    &CutCommand,
    &CopyCommand,
    &PasteCommand,
	&SelectionSeparator,
    &ClearCommand,
    &DelCommand,
	&SelectionSeparator,
    &ParaCommand,
	&SelectionTerminator
};

MenuSelection *Demos[] = {
	&TextBoxCommand,
	&ListBoxCommand,
	&EditBoxCommand,
	&ButtonCommand,
	&SelectionTerminator
};

MenuSelection *Options[] = {
	&InsertCommand,
	&WordWrapCommand,
	&SelectionTerminator
};

MenuBarItem MainMenu[] = {
	MenuBarItem( "~File",    File    ),
	MenuBarItem( "~Edit",    Edit    ),
	MenuBarItem( "~Demos",   Demos   ),
	MenuBarItem( "~Options", Options ),
	MenuBarItem(MENU_TERMINATOR)
};


