// ------- menusel.h

#ifndef MENUSEL_H
#define MENUSEL_H

#include <stdio.h>
#include "strings.h"
#include "dfwindow.h"
#include "dflatdef.h"

enum MenuType {
	NORMAL,
	TOGGLE,
	CASCADER,
	SEPARATOR,
	TERMINATOR
};

enum Toggle { Off, On };

class DFWindow;
class PopDown;

#define NULLFUNC (void (DFWindow::*)())NULL

class MenuSelection	{
	String *label;				// selection label
	void (DFWindow::*cmdfunction)();	// selection function
	MenuType type;				// NORMAL, TOGGLE, CASCADER,
								// SEPARATOR, TERMINATOR
	Bool isenabled;				// True = enabled, False = disabled
	int accelerator;			// accelerator key
	PopDown *cascade;			// cascaded menu window
	MenuSelection **cascaders;	// cascaded menu selection list
	Toggle toggle;				// On or Off
	void NullSelection();		// Build a null selection
	friend PopDown;
	void CommonConstructor(	char *Label,
							int Accelerator,
							void (DFWindow::*CmdFunction)(),
							Bool Active,
							MenuType Type,
							Toggle Tgl,
							MenuSelection **Cascaders = NULL);
public:
	MenuSelection(	char *Label, 
					void (DFWindow::*CmdFunction)() = 0,
					int Accelerator=0,
					Bool Active=True );

	MenuSelection(	char *Label,
					void (DFWindow::*CmdFunction)(),
					Toggle Tgl,
					int Accelerator=0,
					Bool Active=True );

	MenuSelection(	char *Label,
					MenuSelection **Cascaders,
					int Accelerator=0,
					Bool Active=True );

	MenuSelection(MenuType Type);

	Bool isEnabled()		{ return isenabled; }
	void Enable()			{ isenabled = True; }
	void Disable()			{ isenabled = False; }
	void SetToggle()		{ toggle = On; }
	void ClearToggle()		{ toggle = Off; }
	void InvertToggle()		{ toggle = toggle == On ? Off : On; }
	Bool isToggled()		{ return (Bool) (toggle == On); };
	Type()                  { return type; }
};

extern MenuSelection SelectionSeparator;
extern MenuSelection SelectionTerminator;

#endif


