typedef unsigned long UINT32;
typedef long          INT32;
typedef unsigned      UINT16;
typedef int           INT16;
typedef char          CHAR8;
typedef unsigned char UCHAR8;

#define UNKNOWN		  0
#define ISO9660		  1
#define HIGHSIERRA	  2

/* Dir Flag stuff */
#define EXIST			0x01
#define DIR				0x02
#define ASSOCFILE		0x04
#define RECORD			0x08
#define PROTECTION		0x10
#define MULTIEXTENT		0x80

struct hsVolDesc {
	UINT32		LbnLSB;
	UINT32		LbnMSB;
	CHAR8		Type;					/* 1			*/
	CHAR8		ID[5];					/* "CDROM"		*/
	UCHAR8		Version;				/* 1			*/
	UCHAR8		Reserved1;
	CHAR8		SysID[32];
	CHAR8		VolID[32];
	UCHAR8		Reserved2[8];
	UINT32		VolSizeLSB;
	UINT32		VolSizeMSB;
	CHAR8		Reserved3[32];
	UINT16		SetSizeLSB;
	UINT16		SetSizeMSB;
	UINT16		SetSeqLSB;
	UINT16		SetSeqMSB;
	UINT16		BlkSizeLSB;
	UINT16		BlkSizeMSB;
	UINT32		PathTabSizeLSB;
	UINT32		PathTabSizeMSB;
	UINT32		PathTabLocLSB;
	UINT32		PathTabLocMSB;
	CHAR8		PathStuff[24];
	CHAR8		DirRec[34];
	CHAR8		VolSetID[128];
	CHAR8		PubID[128];
	CHAR8		PrepID[128];
	CHAR8		AppID[128];
	CHAR8		CopyRightID[32];
	CHAR8		AbstractID[32];
	CHAR8		CreateDate[16];
	CHAR8		ModDate[16];
	CHAR8		ExpDate[16];
	CHAR8		EffDate[16];
	UCHAR8		StdVer;
};

struct hsDirRec {
	UCHAR8		RecLen;
	UCHAR8		ExtRecLen;
	UINT32		ExtLocLSB;
	UINT32		ExtLocMSB;
	UINT32		DataLenLSB;
	UINT32		DataLenMSB;
	CHAR8		Date[6];
	UCHAR8		Flags;
	CHAR8		Reserved1;
	UCHAR8		InterLeave;
	UCHAR8		SkipFactor;
	UINT16		VolSeqNoLSB;
	UINT16		VolSeqNoMSB;
	UCHAR8		FIDLen;
	CHAR8		FileID[1];
};

struct hsDateTime {
	UCHAR8		Yr;				/* base 1900	*/
	UCHAR8		Mon;			/* 1-12			*/
	UCHAR8		Day;			/* 1-31			*/
	UCHAR8		Hr;				/* 0-23			*/
	UCHAR8		Min;			/* 0-59			*/
	UCHAR8		Sec;			/* 0-59			*/
};

struct isoVolDesc {
	CHAR8		Type;			/* 1			*/
	CHAR8		ID[5];			/* "CD001"		*/
	UCHAR8		Version;		/* 1			*/
	UCHAR8		Reserved1;
	CHAR8		SysID[32];
	CHAR8		VolID[32];
	UCHAR8		Reserved2[8];
	UINT32		VolSizeLSB;
	UINT32		VolSizeMSB;
	CHAR8		Reserved3[32];
	UINT16		SetSizeLSB;
	UINT16		SetSizeMSB;
	UINT16		SetSeqLSB;
	UINT16		SetSeqMSB;
	UINT16		BlkSizeLSB;
	UINT16		BlkSizeMSB;
	UINT32		PathTabSizeLSB;
	UINT32		PathTabSizeMSB;
	UINT16		PathTabLocLSB;
	UINT16		PathTabLocMSB;
	CHAR8		PathStuff[12];
	CHAR8		DirRec[34];
	CHAR8		VolSetID[128];
	CHAR8		PubID[128];
	CHAR8		PrepID[128];
	CHAR8		AppID[128];
	CHAR8		CopyRightID[32];
	CHAR8		AbstractID[32];
	CHAR8		CreateDate[16];
	CHAR8		ModDate[16];
	CHAR8		ExpDate[16];
	CHAR8		EffDate[16];
	UCHAR8		StdVer;
};

struct isoDirRec {
	UCHAR8		RecLen;
	UCHAR8		ExtRecLen;
	UINT32		ExtLocLSB;
	UINT32		ExtLocMSB;
	UINT32		DataLenLSB;
	UINT32		DataLenMSB;
	CHAR8		Date[7];
	UCHAR8		Flags;
	UCHAR8		InterLeave;
	UCHAR8		SkipFactor;
	UINT16		VolSeqNoLSB;
	UINT16		VolSeqNoMSB;
	UCHAR8		FIDLen;
	CHAR8		FileID[1];
};

struct isoDateTime {
	UCHAR8		Yr;				/* base 1900	*/
	UCHAR8		Mon;			/* 1-12			*/
	UCHAR8		Day;			/* 1-31			*/
	UCHAR8		Hr;				/* 0-23			*/
	UCHAR8		Min;			/* 0-59			*/
	UCHAR8		Sec;			/* 0-59			*/
	UCHAR8		Offset;			/* -48 - +52	*/
};
