#pragma pack(1)

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include "scsi.h"

char IObuf[512],
	 CmdBuf[512];


void xDump(char *,unsigned,unsigned);

main(int argc, char *argv[])
{
	union REGS regs;
	struct SREGS sregs;
	struct Cmd Cmd;
	unsigned DataSeg,
			 BlkNo;
	int i;


	segread(&sregs);
	DataSeg = sregs.ds;

	/* Check if Scsi tsr is present */
	regs.h.ah = FUNCID;
	regs.h.al = INSTALLCHK;
	int86x(INT2F,&regs,&regs,&sregs);

	if (regs.h.al != 0xff) {
		regs.h.ah = 0x09;
		sregs.ds = DataSeg;
		regs.x.dx = (unsigned)"Scsi tsr not found!\r\n$";
		int86x(0x21,&regs,&regs,&sregs);
		exit(1);
	}

	for (i = 0; i < sizeof(IObuf); i++)
		IObuf[i] = 0;

	regs.x.dx = (unsigned)&Cmd;
	Cmd.ID = 0x00;					/* Scsi ID 0 */
	Cmd.CDB[0] = 0x12;				/* INQ */
	Cmd.CDB[1] = 0x00;				/* Lun */
	Cmd.CDB[2] = 0x00;				/* Log sector MSB */
	Cmd.CDB[3] = 0x00;				/* Log sector LSB */
	Cmd.CDB[4] = 0x30;				/* 30 bytes */
	Cmd.CDB[5] = 0x00;				/* Control Byte */
	Cmd.DSeg = DataSeg;
	Cmd.DOff = (unsigned)IObuf;

	/* Do the cmd */
	regs.h.ah = FUNCID;
	regs.h.al = DOCMD;
	sregs.ds = DataSeg;
	regs.x.dx = (unsigned)&Cmd;
	int86x(INT2F,&regs,&regs,&sregs);
	printf("%02x\r",Cmd.Stat);
	if (Cmd.Stat == 0x00) {
		xDump(IObuf,0x00U,0x50U);
	} else {
		printf("Failed w/status = %02x\n",Cmd.Stat & 0xff);
		xDump(IObuf,0x00U,0x50U);
		exit(1);
	}
	exit(0);
}

char DisBuf[100];

void xDump(char *Buf,unsigned Start,unsigned Len)
{
	int i,
		j,
		Ch;
	char *BufPtr;

	for (i = Start; i < Start + Len; i += 16) {
		BufPtr = DisBuf;
		sprintf(BufPtr,"%05x  ",i);
		BufPtr += 6;
		for (j = 0; j < 16; j++) {
			Ch = *(Buf + i + j) & 0xff;
			sprintf(BufPtr,"%02x ",Ch);
			BufPtr += 3;
		}
		*BufPtr++ = ' ';
		*BufPtr++ = ' ';
		for (j = 0; j < 16; j++) {
			Ch = *(Buf + i + j) & 0xff;
			if (Ch >= ' ')
				*BufPtr++ = Ch;
			else
				*BufPtr++ = '.';
		}
		*BufPtr = '\0';
		puts(DisBuf);
	}
	puts("");
}
