/* Defines for redirector subfunctions */
#define RMDIR		0x01
#define MKDIR		0x03
#define CHDIR		0x05
#define CLOSE		0x06
#define FLUSH		0x07
#define READ		0x08
#define WRITE		0x09
#define LOCK		0x0a
#define UNLOCK		0x0b
#define GETSPACE	0x0c
#define SETATTR		0x0e
#define GETATTR		0x0f
#define RENAME		0x11
#define DELETE		0x13
#define OPEN		0x16
#define CREATE		0x17
#define FINDFIRST	0x1B
#define FINDNEXT	0x1C
#define CLOSEALL	0x1d
#define REDIRECT	0x1e
#define PRINTSET	0x1f
#define FLUSHALL	0x20
#define SEEK		0x21
#define PATHNAME	0x23
#define PRINTREDIR	0x25
#define EOPEN		0x2e

/* Result codes */
#define FILENOTFOUND	0x02
#define PATHNOTFOUND	0x03
#define ACCESSDENIED	0x05
#define NOMOREFILES		0x12
#define WRITEFAULT		0x1d
#define READFAULT		0x1e
#define GENERALFAILURE	0x1f
#define PATHSEPARATOR	'\\'

/* DOS Current directory structure */
struct CDS {
	CHAR8		CurDir[67];
	UINT16		Flags;
	CHAR8		Unused[10];
	UINT16		RootOff;
};

/* DOS Search Data Block */
struct SDB {
	CHAR8		DriveLet;				/* Drive Letter					*/
	CHAR8		TemPlate[11];			/* Search template				*/
	CHAR8		Sattr;					/* Search attribute				*/
	UINT16		Entry;					/* Entry Count within dir		*/
	UINT32		ParentBlk;				/* Blk # of start of parent 	*/
	UINT16		ParentSize;				/* Size of parent, in bytes		*/
};

/* DOS Found Data Block */
struct FDB {
	CHAR8		FName[11];				/* Found Filename				*/
	UCHAR8		Fattr;					/* Attr of found file			*/
	CHAR8		Reserved[10];
	UINT16		FTime;
	UINT16		FDate;
	UINT16		Cluster;
	INT32		FSize;
};

/* DOS list of lists - Versions 3.1 through 4 */
struct LOL {
	CHAR8  			F1[4];
	CHAR8 _far		*SFT;			/* Ptr to System File Tables	*/
	CHAR8			F2[14];
	CHAR8 _far		*CDS;			/* Ptr to Current Dir Array		*/
	CHAR8			F3[7];
	UCHAR8			LastDrive;		/* Last drive (A: = 1)			*/
};

/* System File Table (SFT) */
struct SFT {
	UINT16		RefCnt;			/* Reference count			*/
	UINT16		Mode;			/* Open Mode				*/
	UCHAR8		DirAttrib;
	UINT16		Flags;
	UINT32		DCB;			/* Device control block		*/
	UINT16		Cluster;		/* Initial cluster			*/
	UINT16		HHMMSS;			/* Hour, Min, Sec/2			*/
	UINT16		YYMMDD;			/* Year, Month, Day			*/
	UINT32		FilSiz;			/* file size/EOF location	*/
	UINT32		FilPos;			/* Current file position	*/
	UINT16		RelClstr;		/* clusters from beginning	*/
	UINT16		CurClstr;		/* current cluster			*/
	UINT16		LBN;			/* block number				*/
	UCHAR8		DirIndex;		/* directory index			*/
	CHAR8		Name[11];		/* file name				*/
	CHAR8		Unknown[4];
	UINT16		OwnerMach;		/* machine number of owner	*/
	UINT16		OwnerPSP;		/* psp of owner task		*/
	UINT16		Status;
};

/* Directory entry for internal use */
struct DirEnt {
	CHAR8			FName[11];				/* In DOS format			*/
	UCHAR8			Fattr;					/* Dos Attribute			*/
	UINT16			FTime;					/* In DOS format			*/
	UINT16			FDate;					/* In DOS format			*/
	UINT32			BlkNo;					/* Starting block #			*/
	INT32			FSize;					/* Size, in bytes			*/
	UINT32			ParentBlk;				/* Starting block #, parent	*/
	struct DirEnt	*Forw;					/* Next (queueing)			*/
	struct DirEnt	*Back;					/* Previous (queueing)		*/
};
