#pragma pack(1)

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include "scsi.h"

char IObuf[512],
	 CmdBuf[512];


void xDump(char *,unsigned,unsigned);

main(int argc, char *argv[])
{
	union REGS regs;
	struct SREGS sregs;
	struct ScsiCmd ScsiCmd;
	unsigned DataSeg,
			 BlkNo;
	int i;


	segread(&sregs);
	DataSeg = sregs.ds;

	/* Check if Scsi tsr is present */
	regs.h.ah = FUNCID;
	regs.h.al = INSTALLCHECK;
	int86x(INTVECTOR,&regs,&regs,&sregs);

	if (regs.h.al != 0xff) {
		regs.h.ah = 0x09;
		sregs.ds = DataSeg;
		regs.x.dx = (unsigned)"Scsi tsr not found!\r\n$";
		int86x(0x21,&regs,&regs,&sregs);
		exit(1);
	}

	regs.x.dx = (unsigned)&ScsiCmd;
	ScsiCmd.ScsiID = 0x00;				/* Scsi ID 0 */
	ScsiCmd.Cmd[0] = 0x03;				/* ReqSense */
	ScsiCmd.Cmd[1] = 0x00;				/* Lun */
	ScsiCmd.Cmd[2] = 0x00;				/* Log sector MSB */
	ScsiCmd.Cmd[3] = 0x00;				/* Log sector LSB */
	ScsiCmd.Cmd[4] = 0x30;				/* Large # */
	ScsiCmd.Cmd[5] = 0x00;				/* Control Byte */
	ScsiCmd.DataSeg = DataSeg;
	ScsiCmd.DataOff = (unsigned)IObuf;

	/* Do the cmd */
	regs.h.ah = FUNCID;
	regs.h.al = DOCMD;
	sregs.ds = DataSeg;
	regs.x.dx = (unsigned)&ScsiCmd;
	int86x(INTVECTOR,&regs,&regs,&sregs);
	printf("Status: %02x\r",ScsiCmd.Status);
	if (ScsiCmd.Status == 0x00) {
		xDump(IObuf,0x00U,0x50U);
	} else {
		printf("Failed w/status = %02x\n",ScsiCmd.Status);
		exit(1);
	}
	exit(0);
}

char DisBuf[100];

void xDump(char *Buf,unsigned Start,unsigned Len)
{
	int i,
		j,
		Ch;
	char *BufPtr;

	for (i = Start; i < Start + Len; i += 16) {
		BufPtr = DisBuf;
		sprintf(BufPtr,"%05x  ",i);
		BufPtr += 6;
		for (j = 0; j < 16; j++) {
			Ch = *(Buf + i + j) & 0xff;
			sprintf(BufPtr,"%02x ",Ch);
			BufPtr += 3;
		}
		*BufPtr++ = ' ';
		*BufPtr++ = ' ';
		for (j = 0; j < 16; j++) {
			Ch = *(Buf + i + j) & 0xff;
			if (Ch >= ' ')
				*BufPtr++ = Ch;
			else
				*BufPtr++ = '.';
		}
		*BufPtr = '\0';
		puts(DisBuf);
	}
	puts("");
}
