#pragma pack(1)

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "scsi.h"

char IObuf[1024 * 0x10],
	 CmdBuf[512];


void xDump(char *,unsigned,unsigned);

main(int argc, char *argv[])
{
	union REGS regs;
	struct SREGS sregs;
	struct Cmd Cmd;
	unsigned DataSeg;
	unsigned long BlkNo,
				  NumBlks;
	int i,
		CmdID;

	segread(&sregs);
	DataSeg = sregs.ds;

	/* Check if Scsi tsr is present */
	regs.h.ah = FUNCID;
	regs.h.al = INSTALLCHK;
	int86x(INT2F,&regs,&regs,&sregs);

	if (regs.h.al != 0xff) {
		regs.h.ah = 0x09;
		sregs.ds = DataSeg;
		regs.x.dx = (unsigned)"Scsi tsr not found!\r\n$";
		int86x(0x21,&regs,&regs,&sregs);
		exit(1);
	}

	regs.x.dx = (unsigned)&Cmd;
	Cmd.ID = 0x00;					/* Scsi ID 0 */
	Cmd.CDB[0] = 0x28;				/* Read */
	Cmd.CDB[1] = 0x00;				/* Lun */
	Cmd.CDB[2] = 0x00;				/* Log sector MSB */
	Cmd.CDB[3] = 0x00;				/* Log sector     */
	Cmd.CDB[4] = 0x00;				/* Log sector     */
	Cmd.CDB[5] = 0x00;				/* Log sector LSB */
	Cmd.CDB[6] = 0x00;				/* Reserved */
	Cmd.CDB[7] = 0x00;
	Cmd.CDB[8] = 0x01;				/* 1 block */
	Cmd.CDB[9] = 0x00;				/* Control Byte */
	Cmd.DSeg = DataSeg;
	Cmd.DOff = (unsigned)IObuf;

	for (;;) {
		printf("(R)ead (Q)uit:");
		gets(CmdBuf);
		CmdID = *CmdBuf & 0xff;
		switch (CmdID) {
			case 'r':
			case 'n':
			case 'p':
			case '+':
			case '-':
				Cmd.CDB[0] = 0x28; break;
			case 'q':
				exit(0);
			default:
				printf("Unknown cmd - try again.\n");
				continue;
		}
		*CmdBuf = ' ';
		NumBlks = 1L;
		switch (CmdID) {
			case 'r':
				sscanf(CmdBuf,"%lx %lx",&BlkNo,&NumBlks);
				break;
			case 'n':
			case '+':
				BlkNo++;
				break;
			case 'p':
			case '-':
				BlkNo--;
				break;
		}
		/* Do the cmd */
		regs.h.ah = FUNCID;
		regs.h.al = DOCMD;
		sregs.ds = DataSeg;
		regs.x.dx = (unsigned)&Cmd;
		Cmd.CDB[2] = (BlkNo >> 24U) & 0xffL;
		Cmd.CDB[3] = (BlkNo >> 16U) & 0xffL;
		Cmd.CDB[4] = (BlkNo >> 8U) & 0xffL;
		Cmd.CDB[5] = BlkNo & 0xffL;
		Cmd.CDB[7] = (NumBlks >> 8U) & 0xffL;
		Cmd.CDB[8] = NumBlks & 0xffL;
		Cmd.Count = 512 * NumBlks;
		int86x(INT2F,&regs,&regs,&sregs);
		printf("Block %08lx:\n",BlkNo);
		if (Cmd.Stat == 0x00) {
			printf("Count = %x\n",Cmd.Count);
			xDump(IObuf,0x00U,0x800U);
		} else {
			printf("Failed w/status = %02x\n",Cmd.Stat);
			printf("Count = %x\n",Cmd.Count);
			xDump(IObuf,0x00U,0x100U);
		}
	}
	exit(0);
}

char DisBuf[100];

void xDump(char *Buf,unsigned Start,unsigned Len)
{
	int i,
		j,
		Ch;
	char *BufPtr;

	for (i = Start; i < Start + Len; i += 16) {
		BufPtr = DisBuf;
		sprintf(BufPtr,"%04x(%04d)  ",i,i+1);
		BufPtr += 12;
		for (j = 0; j < 16; j++) {
			Ch = *(Buf + i + j) & 0xff;
			sprintf(BufPtr,"%02x ",Ch);
			BufPtr += 3;
		}
		*BufPtr++ = ' ';
		*BufPtr++ = ' ';
		for (j = 0; j < 16; j++) {
			Ch = *(Buf + i + j) & 0xff;
			if (Ch >= ' ')
				*BufPtr++ = Ch;
			else
				*BufPtr++ = '.';
		}
		*BufPtr = '\0';
		puts(DisBuf);
	}
	puts("");
}
