/*
 * Structure passed to scsi transport layer,
 * ds:dx==> ScsiCmd
 * Interrupt 2F, Function 7f (AH = 7F)
 * Subfunctions (AL):
 * 			Installcheck: AL = 0x00
 * 				returns:  AL = 0xff, already installed.
 *			Do Command:   AL = 0x01
 *				returns:  AL = 0x00  success,
 *						  AL = 0xnn  Error nn
 *			Do reset:	  AL = 0x02
 *			Deinstall:	  AL = 0x03
 *				returns:  AL = 0x00  success,
 *						  AL = 0x01  unable to deinstall.
 */

#define RETRYCOUNT 2

struct Cmd {
	char ID;
	char CDB[10];
	unsigned DSeg;
	unsigned DOff;
	char Stat;
	char Sense;
	unsigned Count;
};

#define INT2F			0x2f
#define FUNCID			0x7f

/* Cmds */
#define INSTALLCHK		0x01
#define DOCMD			0x02
#define DORESET			0x03
#define DEINSTALL		0x04
