/* Bit flags to denote audio driver capabilities. */
/* returned by the AudioCapabilities call.				*/
#define PLAYBACK 1    // Bit zero true if can play audio in the background.
#define MASSAGE  2    // Bit one is true if data is massaged.
#define FIXEDFREQ 4   // Bit two is true if driver plays at fixed frequency.
#define USESTIMER 8   // Bit three is true, if driver uses timer.

typedef struct
{
  char far *sound;     // address of audio data.
  unsigned int sndlen; // Length of audio sample.
  int far  *IsPlaying; // Address of play status flag.
  int	   frequency;  // Playback frequency.
} SNDSTRUC;

int  far DigPlay(SNDSTRUC far *sndplay); // 688h -> Play 8 bit digitized sound.
int  far SoundStatus(void);  // 689h -> Report sound driver status.
void far MassageAudio(SNDSTRUC far *sndplay); // 68Ah -> Preformat 8 bit digitized sound.
void far DigPlay2(SNDSTRUC far *sndplay); // 68Bh -> Play preformatted data.
int  far AudioCapabilities(void); // 68Ch -> Report audio driver capabilities.
int  far ReportSample(void); // 68Dh -> Report current sample address.
void far SetCallBackAddress(void far *proc); // 68Eh -> Set procedure callback address.
void far StopSound(void); // 68Fh -> Stop current sound from playing.
void far *far ReportCallbackAddress(void); // 691h -> report current callback address.

/* Support routines */
void far WaitSound(void); // Wait until sound playback completed.
int  far CheckIn(void);   // Is sound driver available? 0 no, 1 yes.

