/**************************************************************************************************
*
*		Title:	RJUSER.H
*
*		This file contains all the prototypes and definitions used by the video function library.
*
**************************************************************************************************/

#define	_RJUSER_H_
#ifndef FAR
	#ifdef __386__
		#define	HUGE
		#define	FAR
	#else
		#define	HUGE	huge
		#define	FAR		far
	#endif
#endif
#ifdef __WATCOMC__
	#ifdef __SMALL__
		#pragma library ("wcuser_s.lib");
	#else
		#pragma library ("wcuser_l.lib");
	#endif

	#ifndef	_MS_C_
		#define	_MS_C_
		#pragma aux MS_C	"_*" \
							parm caller [] \
							value struct float struct routine [ax] \
							modify [ax bx cx dx es];
	#endif
#endif
#pragma	pack(1)

/**************************************************************************************************
*
*										EQUATES
*
**************************************************************************************************/

#define	PRINT_DEFAULT_LENGTH	10
#define	PRINT_BUFFER_SIZE		80


/**************************************************************************************************
*
*		Definitions for screen colors
*
**************************************************************************************************/

#define	BLACK		0
#define	BLUE		1
#define	GREEN		2
#define	CYAN		3
#define	RED			4
#define	MAGENTA		5
#define	BROWN		6
#define	WHITE		7
#define	INTENSE		0x8 ^
#define	BLINK		0x80 ^
#define	BACKGROUND	<< 4
#define	YELLOW		(INTENSE BROWN)

#define	DOUBLE_LINE		0
#define	SINGLE_LINE		1
#define	SINGLE_DOUBLE	2	/* single lined sides, double lined top */
#define	DOUBLE_SINGLE	3	/* double lined sides, single lined top */
#define	NO_LINE			4	/* No line displayed */


/**************************************************************************************************
*
*		Definitions for logical statments
*
**************************************************************************************************/

#define	TRUE		1
#define	FALSE		0
#define	SECONDS		* 18
#define	MINUTES		* 1092
#define	KBYTES		* 1024
#define	PI			3.14159265358979323846


/**************************************************************************************************
*
*		Definitions for keys
*
***************************************************************************************************/

#define	TAB			9
#define	LF			10
#define	CR			13
#define	ESC			27
#define	BACKSPACE	'\b'
#define	SPACE		0x20
#define	UP			0xff48
#define	DOWN		0xff50
#define	RIGHT		0xff4d
#define	LEFT		0xff4b
#define	HELP_KEY	0xff44
#define	PAGE_UP		0xff49
#define	PAGE_DOWN	0xff51
#define	HOME		0xff47
#define	END_KEY		0xff4f
#define DEL			0xFF53
#define INS			0xFF52
#define	F1_KEY		0xff3b
#define	F2_KEY		0xff3c
#define	F3_KEY		0xff3d
#define	F4_KEY		0xff3e
#define	F5_KEY		0xff3f
#define	F6_KEY		0xff40
#define	F7_KEY		0xff41
#define	F8_KEY		0xff42
#define	F9_KEY		0xff43
#define	F10_KEY		0xff44

/**************************************************************************************************
*
*		Definitions for ALT- keys
*
**************************************************************************************************/

#define	ALT_A		0xff1e
#define	ALT_B		0xff30
#define	ALT_C		0xff2e
#define	ALT_D		0xff20
#define	ALT_E		0xff12
#define	ALT_F		0xff21
#define	ALT_G		0xff22
#define	ALT_H		0xff23
#define	ALT_I		0xff17
#define	ALT_J		0xff24
#define	ALT_K		0xff25
#define	ALT_L		0xff26
#define	ALT_M		0xff32
#define	ALT_N		0xff31
#define	ALT_O		0xff18
#define	ALT_P		0xff19
#define	ALT_Q		0xff10
#define	ALT_R		0xff13
#define	ALT_S		0xff1f
#define	ALT_T		0xff14
#define	ALT_U		0xff16
#define	ALT_V		0xff2f
#define	ALT_W		0xff11
#define	ALT_X		0xff2d
#define	ALT_Y		0xff15
#define	ALT_Z		0xff2c

#define	ALT_F1		0xff68
#define	ALT_F2		0xff69
#define	ALT_F3		0xff6a
#define	ALT_F4		0xff6b
#define	ALT_F5		0xff6c
#define	ALT_F6		0xff6d
#define	ALT_F7		0xff6e
#define	ALT_F8		0xff6f
#define	ALT_F9		0xff70
#define	ALT_F10		0xff71


/**************************************************************************************************
*
*		Definitions for control keys
*
**************************************************************************************************/

#define	CTRL_A		1
#define	CTRL_B		2
#define	CTRL_C		3
#define	CTRL_D		4
#define	CTRL_E		5
#define	CTRL_F		6
#define	CTRL_G		7
#define	CTRL_H		8
#define	CTRL_I		9
#define	CTRL_J		10
#define	CTRL_K		11
#define	CTRL_L		12
#define	CTRL_M		13
#define	CTRL_N		14
#define	CTRL_O		15
#define	CTRL_P		16
#define	CTRL_Q		17
#define	CTRL_R		18
#define	CTRL_S		19
#define	CTRL_T		20
#define	CTRL_U		21
#define	CTRL_V		22
#define	CTRL_W		23
#define	CTRL_X		24
#define	CTRL_Y		25
#define	CTRL_Z		26

#define	CTRL_F1		0xff5e
#define	CTRL_F2		0xff5f
#define	CTRL_F3		0xff60
#define	CTRL_F4		0xff61
#define	CTRL_F5		0xff62
#define	CTRL_F6		0xff63
#define	CTRL_F7		0xff64
#define	CTRL_F8		0xff65
#define	CTRL_F9		0xff66
#define	CTRL_F10	0xff67

#define	CTRL_HOME		0xff77
#define	CTRL_END		0xff75
#define	CTRL_PAGE_UP	0xff84
#define	CTRL_PAGE_DOWN	0xff76


#define	MACRO_MODE		-1
#define	MACRO_WORD		1
#define	MACRO_KEYWAIT	2


/**************************************************************************************************
*
*		Window definitions
*
**************************************************************************************************/

#define	WINDOW_OPEN		1				/* Set if window is open now.	*/
#define	WINDOW_CLOSED	2				/* This set means that the window could be re-opened	*/
#define	WINDOW_BORDER	4				/* This set means window should have a border	*/


/**************************************************************************************************
*
*								File Access Definitions
*
**************************************************************************************************/

#define	OPEN_RO			0
#define	OPEN_WO			1
#define	OPEN_RW			2
#define	OPEN_CREATE		8
#define	DENY_RW			0x10
#define	DENY_WRITE		0x20
#define	DENY_READ		0x30
#define	DENY_NONE		0x40
#define	INHERIT			0x80

#define	SEEK_START		0			/* Seek from the beginning of the file */
#define	SEEK_CURRENT	1			/* Seek from the current file position */
#define	SEEK_END		2			/* Seek from the end of the file */


/**************************************************************************************************
*
*							Predefined File Handles
*
**************************************************************************************************/

#define	STDIN			0				/* Input device, normally the keyboard */
#define	STDOUT			1				/* Output device, normally the display */
#define	STDERR			2				/* Error logging device */
#define	STDAUX			3				/* Standard auxilary port */
#define	STDPRN			4				/* Printer */


/**************************************************************************************************
*
*							File Sort Definitions
*
**************************************************************************************************/

#define	SORT_NOTHING	0
#define	SORT_NAME		1				/* Files are sorted by name */
#define	SORT_EXTENSION	2				/* Files are sorted by extension */
#define	SORT_DATE		3				/* Files are sorted by date/time stamp */
#define	SORT_ATTRIBUTE	4				/* Files are sorted by attribute */
#define	SORT_NAME_ATT	5
#define	SORT_MAX		5


/**************************************************************************************************
*
*							File Sort Definitions
*
**************************************************************************************************/

#define	ATT_READ_ONLY	0x01
#define	ATT_HIDDEN		0x02
#define	ATT_SYSTEM		0x04
#define	ATT_LABEL		0x08
#define	ATT_DIRECTORY	0x10
#define	ATT_ARCHIVE		0x20


/**************************************************************************************************
*
*		TEMPLATE EQUATES
*
**************************************************************************************************/

#define	NO_RESPONSE		0				// Do not expect a response
#define	STRING			1				// Defines an ASCIIZ string
#define	US				2				// Defines an unsigned integer
#define	SS				3				// Defines a signed integer
#define	UL				4				// Defines an unsigned long
#define	SL				5				// Defines a signed long
#define	UB				6				// Defines an unsigned byte
#define	SB				7				// Defines a signed byte
#define	FLOAT			8				// Defines a floating point number
#define	DOUBLE			9				// Defines a double floating point number
#define	BIT				10				// Defines a boolean response
#define	END_TEMPLATE	0xff			// Last template entry

#define DISP_10			0x00			// Display '1' or '0' for bit definition
#define DISP_YN			0x10			// Display 'Y' or 'N' for bit definition
#define DISP_TF			0x20			// Display 'T' or 'F' for bit definition
#define DISP_LC			0x80			// Show the displayed bit in lower case.

#define	MAX_DATA_WINDOWS	20
#define	BOXED_ENTRY			0x100
#define	ENTRY_BIT0			0x000
#define	ENTRY_BIT1			0x200
#define	ENTRY_BIT2			0x400
#define	ENTRY_BIT3			0x600
#define	ENTRY_BIT4			0x800
#define	ENTRY_BIT5			0xa00
#define	ENTRY_BIT6			0xc00
#define	ENTRY_BIT7			0xe00


/**************************************************************************************************
*
*								Index and Locking Definitions
*
**************************************************************************************************/

#define	LOCK	1			/* Flag for locking functions to request a lock before the function occurs */
#define	UNLOCK	2			/* Flag for locking functions to request a lock after the function leaves */

#define	ERR_NOT_EXIST	-80				/* Record does not exist */
#define	ERR_INCOMPLETE	-81				/* Record is an incomplete size */
#define	ERR_TIMEOUT		-82				/* Access to the file or record timed out */
#define	ERR_BOF			-83				/* Access went below the beginning of the file */
#define	ERR_EOF			-84				/* Access went beyond the end of the file */
#define	ERR_STRUCTURE	-85				/* Bad structure in the index file */
#define	ERR_NO_MEMORY	-86				/* Not enough memory for the operation */
#define	ERR_NO_ROOM		-87				/* Disk just overflowed */
#define	ERR_MATCH		-88				/* Insertion had a matching entry */

#define	VERSION_MSB		0				/* Current software version, most significant byte */
#define	VERSION_LSB		1				/* least significant byte */

#define	TYPE_DATA		1
#define	TYPE_INDEX		0

#define	LOCK_FILE(x)	time_file_lock( x, 0 )
#define	UNLOCK_FILE(x)	dos_unlock( x, 0L, -1L )

#define	INT3			_asm {int	3};

/**************************************************************************************************
*
*										STRUCTURES
*
**************************************************************************************************/

#ifndef	uc
typedef	unsigned char	uc;
typedef	unsigned short	us;
typedef	unsigned int	ui;
typedef	unsigned long	ul;
#endif

typedef union
{
	char			*cp;
	unsigned char	*ucp;
	short			*sp;
	unsigned short	*usp;
	int				*ip;
	unsigned int	*uip;
	long			*lp;
	unsigned long	*ulp;
	float			*fp;
	double			*dp;
} ALLPTR_T;

typedef union
{
	char			FAR *cp;
	unsigned char	FAR *ucp;
	short			FAR *sp;
	unsigned short	FAR *usp;
	int				FAR *ip;
	unsigned int	FAR *uip;
	long			FAR *lp;
	unsigned long	FAR *ulp;
	float			FAR *fp;
	double			FAR *dp;
} ALLFPTR_T;


typedef struct WINDOW_S				/* Internal structure used by the window managers */
{
	short	x1,y1,x2,y2;			/* Upper left and lower right coordinates of the window */
	uc	FAR *buffer;				/* -> buffer used for window storage */
	uc		flags;					/* Flags used by the window */
	uc		type;					/* Type of border character */
	uc		title[20];				/* Storage used for the window */
	uc		cattrib, battrib;		/* Attributes used for the characters and the border */
	short	offset;					/* Start of the window in display memory */
	short	width;					/* Inner width of the window */
	short	start;					/* First character space of the current line */
	short	end;					/* Last character space of the current line */
	short	last_offset;			/* Last offset used in the window */
	short	last_x, last_y;			/* Last cursor coordinate */
} WINDOW_T;


typedef struct CHOOSE_HEADER_S
{
	us	x1, y1, x2, y2;		/* Clear screen variables	*/
	uc	background;			/* Background attribute		*/
	us	title_y;
	us	highlight;			/* Selection highlight		*/
	us	string_attribute;	/* Attribute to use w/normal string */
	us	char_attribute;		/* Attribute to use w/select character */
	uc	*title;				/* Title of this field	*/
	us	title_attribute;	/* Attribute used for the title	*/
} CHOOSE_HEADER_T;


typedef struct CHOICE_S
{
	us	x, y;		/* X,Y coordinates of the selection */
	us	left;		/* Where to go, left button is pushed */
	us	right;		/* Where to go, right button is pushed */
	us	up;			/* Where to go, up button is pushed */
	us	down;		/* Where to go, down button is pushed */
	uc	*string;	/* String to display */
	uc	*help_key;	/* Pointer to the help key for this selection */
	uc	key_select;	/* Character that chooses this string */
	union
	{
		us	the_int;
		us	(*function)();
	} key_return;	/* US to return if this is chosen */
} CHOICE_T;


typedef struct MENU_BAR_ENTRY_S
{
	char *title;					/* Menu entry display */
	us hot_key;						/* Hot key for this value */
	int (*function)();				/* -> function that is called with the main hotkey and this hotkey */
	uc *help;						/* -> help string to display */
} MENU_BAR_ENTRY_T;


typedef struct MENU_COLOR_S
{
	us norm_fore;			/* Normal foreground color */
	us norm_back;			/* Normal background color */

	us sel_fore;			/* Selected foreground color */
	us sel_back;			/* Selected backgound color */

	us wnorm_fore;			/* Window normal foreground color */
	us wnorm_back;			/* Window normal background color */

	us wsel_fore;			/* Window selected foreground color */
	us wsel_back;			/* Window selected backgound color */

	us hot_fore;			/* Foreground color of the hotkey character */
	us hot_back;			/* Background color of the hotkey character */

	us whot_fore;			/* Window foreground color of the hotkey character */
	us whot_back;			/* Window background color of the hotkey character */
} MENU_COLOR_T;


typedef struct MENU_BAR_S
{
	char *title;					/* -> title for this menu item */
	us x,y;							/* Location of this title */
	char *status;					/* Status line string */
	us hot_key;						/* Key if pressed will jump to this menu entry */
	int (*function)( struct MENU_BAR_S * );			/* Function to call with this hotkey if this is selected */
	us x1,y1,x2,y2;					/* Dimensions of the drop down window created */
	us entries;						/* Number of entries in the entry array to follow */
	MENU_BAR_ENTRY_T *entry;		/* -> array of entries to use */
} MENU_BAR_T;


typedef struct TEMPLATE_S
{
	int	x, y;				// X,Y location of question
	int	answer_x, answer_y;	// X,Y location of answer buffer
	int	page;				// Page number that this set is on
	uc	length;				// maximum length of the answer
	uc	type;				// Type of answer
	uc	bit_offset;			// Bit offset from offset byte for storage
	uc	bit_length;     	// Bit length of data field; 0=normal type
	ul	offset;				// Byte offset into buffer to store this
	double	minimum,		// Minimum and maximum values
			maximum;
	char	*question;			// -> question string
	char	*prompt;			// -> prompt string
	char	*default_value;		// -> default if nothing entered
	char	*help_string;		// -> complex string to display for help
} TEMPLATE_T;


typedef struct CTEMPLATE_S
{
	char	filename[128];			// Name of file this template is associated with
	char	*read_mask;				// -> search mask to use for file read accesses
	char	*write_dir;				// Directory to use for file writes
	int		handle;					// Handle used for the file access
	long	file_offset;			// Byte offset to place/read the data
	long	write_seek;				// Number of bytes to seek after a write
	long	read_seek;				// Number of bytes to seek after a read
	int		(*write_function)();	// -> function to call when write key is pressed
	int		(*read_function)();		// -> function to call when read key is pressed

	us		exit_key;				// Key used to exit the template function
	us		help_key;				// Key used to signal help
	us		write_key;				// Key used to write the data to the file
	us		read_key;				// Key used to read the data from the file
	us		save_key;				// Key used to save the data to the buffer it was taken from
	us		reread_key;				// Key used to read the data from the buffer it was taken from
	us		restore_key;			// Key to used to restore the current entry to its original value

	int		x1,y1, x2,y2;			// Corners of the window
	int		page_x, page_y;			// Coordinates of the page number

	uc		body_color;				// Attribute to use for the body
	uc		select_color;			// Attribute to use for a selected entry

	struct
	{
		int	exit	: 1;			// Set if confirm exit
		int	change_exit : 1;		// Set if confirm on exit if changes were made
		int	write	: 1;			// Set if confirm write to a file
		int	read	: 1;			// Set if confirm read from file
		int	save	: 1;			// Set if confirm save to a buffer
		int	reread	: 1;			// Set if confirm reread from a buffer
		int	restore	: 1;			// Set if confirm restore from a buffer
	} confirm;

	struct
	{
		int	save_exit		: 1;	// 1 = data will be saved upon exit without prompting user
		int	close_file		: 1;	// Set to 1 if the file is closed before every return
		int	ask_read_file	: 1;	// Set to 1 if the read filename must be prompted for
		int	ask_write_file	: 1;	// Set to 1 if the write filename must be prompted for
		int	read_support	: 1;	// Set to 1 if function supports file reads
		int	write_support	: 1;	// Set to 1 if function supports file writes
	} flag;
} CTEMPLATE_T;


typedef struct DOS_TIME_S
{
	us	two_second : 5;
	us	minute : 6;
	us	hour : 5;
} DOS_TIME_T;


typedef struct DOS_DATE_S
{
	us	day : 5;
	us	month : 4;
	us	year : 7;
} DOS_DATE_T;


typedef struct DIR_ATTRIBUTE_S
{
	uc	read_only :	1;		/* Set if this file is a read only file */
	uc	hidden :	1;		/* Set if this file is not to be displayed by DIR */
	uc	system :	1;		/* Set if this file is a system file, has no real meaning */
	uc	label :		1;		/* Set if this file entry is a volume label */
	uc	directory :	1;		/* Set if this file entry is a directory */
	uc	archive :	1;		/* Set whenever the file has been written to */
} DIR_ATTRIBUTE_T;


typedef struct FILE_S
{
	ul				size;
	union
	{
		us			date;
		struct
		{
			unsigned short	day		: 5;
			unsigned short	month	: 4;
			unsigned short	year	: 7;
		};
	};
	union
	{
		us			time;
		struct
		{
			unsigned short	two_second	: 5;
			unsigned short	minute		: 6;
			unsigned short	hour		: 5;
		};
	};
	DIR_ATTRIBUTE_T	attribute;
	char		name[1];	/* Start of the file name */
} FILE_T;


typedef struct WN_DATA_ENTRY_S
{
	struct WN_DATA_ENTRY_S FAR *next;		// Next structure in the list, NULL means it is at an end
	struct WN_DATA_ENTRY_S FAR *prev;		// Previous structure in the list, first entry is NULL
	struct WN_DATA_ENTRY_S FAR *right;
	struct WN_DATA_ENTRY_S FAR *left;
	struct WN_DATA_ENTRY_S FAR *up;
	struct WN_DATA_ENTRY_S FAR *down;
	us type;								// Data type
	int x, y;								// X,Y coordinates relative to the window corner
	us width;								// Width of the data entry value or string to output
	uc color;								// Color for the data entry area
	uc holder;								// Place holder for data entry
	void FAR *buffer;						// -> buffer used with this entry
} WN_DATA_ENTRY_T;


typedef	struct WN_DATA_S
{
	WN_DATA_ENTRY_T FAR *first;				// -> first data entry descriptor
	WINDOW_T wn;							// Window structure for this handle
} WN_DATA_T;


typedef struct DECODE_S				// Structure for reading in definition files
{
	int		data_type;				// Type of data defined in RJUSER.H
	int		buffer_size;			// Size of the buffer pointed to by BUFFER, this is used with STRING and BIT types
	char	*match_string;			// -> string to match up with the key words in the definition file
	void	FAR *buffer;			// -> buffer to placed the parsed data
} DECODE_T;


typedef struct CMOS_S				// Structure for the real-time clock
{
	uc	seconds;					// Seconds in binary (converted)
	uc	second_alarm;				// Seconds portion of the alarm
	uc	minutes;					// Minutes in binary (converted)
	uc	minute_alarm;				// Minutes portion of the alarm
	uc	hour;						// Hour in binary (converted)
	uc	hour_alarm;					// Hour portion of the alarm
	uc	day_of_week;				// Day of the week, 0=Sunday
	uc	day;						// Day of the month
	uc	month;						// Month, 0=January
	uc	year;						// Year in binary (converted)
	uc	status_A;					// Status register A
	uc	status_B;					// Status register B
	uc	status_C;					// Status register C
	uc	status_D;					// Status register D
	uc	diagnostic;					// Diagnostic status byte
	uc	shutdown;					// Shutdown status byte
	uc	floppy_type;				// Type numbers for A and B floppies
	uc	reserved1;
	uc	HD_type;					// Type numbers for hard disk 80h and 81h
	uc	reserved2;
	uc	equipment;					// Equipment byte
	us	base_memory;				// System base memory in K
	us	extended_memory;			// System expansion memory in K
	uc	drive_C;					// 1st hard disk extended type byte
	uc	drive_D;					// 2nd hard disk extended type byte
	uc	reserved3[19];
	us	checksum;					// Checksum of floppy_type - reserved3, inclusive
	us	ext_memory;					// Same as extended_memory
	uc	century;					// Century for the date in binary (converted)
	uc	info_flag;					// Information flags
	uc	reserved[12];
} CMOS_T;


/**************************************************************************************************
*
*									Index Structures
*
**************************************************************************************************/

typedef struct ISAM_FILE_HEADER_S
{
	us	header_size;			/* Size of the ISAM file header */
	uc	version_major;			/* Major version number */
	uc	version_minor;			/* Minor version number */
	us	file_type;				/* Type of file that this is */
								/* Bit 0: 0=index, 1=datafile */
	ul	total_entries;			/* Number of entries in this index */
	us	match_offset;			/* Offset into a datafile entry for a match */
	ul	total_writes;			/* Number oif writes done to this index */
	uc	datafile_name[66];		/* Name of the datafile that this index is associated with */
} ISAM_FILE_HEADER_T;


typedef struct DATA_FILE_HEADER_S
{
	us	header_size;			/* Size of this header entry */
	uc	version_major;			/* Major version number */
	uc	version_minor;			/* Minor version number */
	us	file_type;				/* Type of file that this is */
								/* Bit 0: 0=index, 1=datafile */
	ul	total_entries;			/* Number of entries in this index */
	us	entry_size;				/* Size of a single entry */
	ul	first_available;		/* Offset of the first available entry */
} DATA_FILE_HEADER_T;


typedef struct INDEX_S
{
	int	index_handle;			/* Handle for the index file */
	ul	total_writes;			/* Number of writes done to this index, last time it was read */
	ul	index_entries;			/* Number of entries in this index, last time it was read */
	us	index_start;			/* Start of the index table in the index file */
	ul	HUGE *table_start;		/* -> storage for the index table */
	ul	current_entry;			/* Current entry in the index table */

	int	data_handle;			/* Handle for the data file */
	us	data_writes;			/* Number of writes done to the data file record, not to the whole file */
	us	data_entry_size;		/* Size of a single data file entry */
	us	data_start;				/* Start of the index table in the index file */
	ul	data_entries;			/* Number of data entries in theis data file */
	uc	FAR *entry_buffer;		/* Buffer used for reading a single entry in */
	us	match_offset;			/* Offset into a datafile entry for a match */
	ul	data_entry;				/* Offset of the current entry in the data file */
} INDEX_T;


/**************************************************************************************************
*
*		Pre-defined public variables
*
**************************************************************************************************/

extern	us (FAR *_Char_Process)();
extern	int Virgin_Screen;
extern	us	_Screen_Height, _Screen_Width, _Screen_Segment;
extern	uc	_Clear_Screen_Char;
extern	us	_Window_Line_Table[11][6];
extern	us	_Access_Timeout;
extern	CTEMPLATE_T	_Template_Control, *_Tc;


/**************************************************************************************************
*
*									FUNCTION PROTOTYPES
*
**************************************************************************************************/

extern	ul atoh( char * );
extern	void raw_out( uc, uc );
extern	void achar_out( uc, uc );
extern	uc *get_soffset( void ), FAR *get_segoffset( void );
extern	void set_soffset( uc * );
extern	void _place_cursor( void );
extern	uc get_attribute( void );
extern	void set_attribute( uc );
extern	uc normal_attribute( uc );
extern	void clear_area( int,int, int,int, uc );
extern	void (*set_help( void (*)() ))();			/* *FUNCTION */
extern	uc get_mode( void );
extern	uc set_mode( uc );							/* mode */
extern	void set_screen_segment( us );				/* segment of the display memory area */
extern	void auto_screen( void );					/* checks for the type of screen */
extern	us	show_cursor( void );					/* Shows the current cursor */
extern	us	no_cursor( void );
extern	us	set_cursor( us );						/* style */
extern	void goto_xy( int, int );						/* X, Y */
extern	us	get_xy( int *, int * );					/* &X, &Y */
extern	void clear_screen( uc );					/* attribute */
extern	void clear_line( us, uc );					/* Y, attribute */
extern	void scroll_up( us, us, us, us, uc );		/* X1,Y1, X2,Y2, attribute */
extern	void scroll_down( us, us, us, us, uc );		/* X1,Y1, X2,Y2, attribute */
extern	void scroll_screen( void );					/* scrolls entire display screen */
extern	us charin( void );
extern	us FAR _csr_stub( void );
#define	restore_csr()	_Char_Process=_csr_stub
#define	set_csr(x)		_Char_Process=x
extern	int set_key_vector( us, void (*)() );
extern	void char_out( uc );						/* character to display at current cursor position */
extern	void string_out( uc * );					/* string to display at current cursor position */
extern	void box( us, us, us, us, uc, uc );			/* X1,Y1, X2,Y2, line type, attribute */
extern	us center( uc *, us, uc );					/* string, line number, attribute */
extern	void displayat_hex( us, us, us, uc );		/* value, X,Y, attribute */
extern	void displayat_lhex( ul, us, us, uc );		/* value, X,Y, attribute */
extern	void rlhexout( us, ul );					/* spaces to move to the right, value to display */
extern	void rhexout( us, us );						/* spaces to move to the right, value to display */
extern	void rbyteout( us, uc );					/* spaces to move to the right, value to display */
extern	void new_line( void );						/* moves down a display line */
extern	void set_charin_macro( uc FAR * );			/* Sets the macro string */
extern	void put_time( ui, ui );					/* Puts time at X,Y */
extern	int start_timer( ui, ui );
extern	void stop_timer( void );
extern	char *prefix_char( uc *, uc );
extern	char *prefix_string( uc *, uc * );
extern	char *strip_char( char *, char, int );		// Target string, character to strip, max sequence length
extern	char *strmcat( char *, char *, ... );		/* Destination, source string 1, source string 2, ... */
extern	char *strmcpy( char *, char *, ... );		/* Destination, source string 1, source string 2, ... */
extern	int make_complex_dir( uc * );
extern	ui find_longest_substring( char *, ui * );
extern	char *strtime( char *, us );		/* destination buffer, time to stringize */
extern	char *strdate( char *, us );		/* destination buffer, date to stringize */
extern	char *get_date_string( uc * );				/* buffer <- current system date in mm/dd/yy format */
extern	char *get_time_string( uc * );				/* buffer <- current system time in hh:mm:ss format */
extern	void read_cmos( CMOS_T * );
extern	char FAR *fstrnlen( char FAR *, int );

extern	ul crc32( void HUGE *, ul );
extern	us crc16( void HUGE *, ul );

extern	void beep( void );
extern	void wait_for_retrace( void );

extern	short par_out( short, uc );					/* Output a byte to the parallel port thru INT-17h */
extern	short par_init( short );					/* Initialize the parallel port using INT-17h */
extern	short par_status( short );					/* Status of the parallel port using INT-17h */

extern	int wn_open( WINDOW_T * );
extern	int wn_close( WINDOW_T * );
extern	us wn_calc_size( WINDOW_T * );				/* -> WINDOW structure */
extern	int wn_reopen( WINDOW_T * );
extern	int wn_center( WINDOW_T *, char *, int, uc );

extern	us choose_one( CHOOSE_HEADER_T *, CHOICE_T * );
extern 	ui do_template( TEMPLATE_T *, void FAR *, int );

extern	int append_file( uc *, void FAR *, us );					/* path, buffer, count */
extern	void HUGE *dos_alloc( ul );									/* Number of bytes to allocate */
extern	int dos_chdir( char * );									// directory to go to
extern	int dos_close( int );										/* handle */
extern	int dos_create( char *, us );								/* path, attribute */
extern	us dos_date( void );
extern	int dos_delete( uc * );										/* path */
extern	long dos_disk_free( short );								/* Drive number 0=current, 1=A:, ... */
extern	int dos_free( void HUGE * );								/* buffer to free */
extern	int dos_getdir( uc, uc * );									/* Drive, path buffer */
extern	int dos_getdrive( void );									/* return 0=A, ... */
extern	int dos_setdrive( uc );										/* A:=0, B:=1, ... */
extern	int dos_lock( int, long, long );							/* handle, start of region, size of region */
extern	int dos_mkdir( uc * );										/* pathname */
extern	int dos_open( uc *, uc );
extern	int dos_read( int, void FAR *, int );
extern	int dos_ren( uc *, uc * );									/* new name, old name */
extern	int dos_resize( void HUGE *, ul );							/* buffer, new size */
extern	int dos_rmdir( uc * );										/* pathname */
extern	long dos_seek( int, long, uc );
extern	us dos_time( void );
extern	us get_time( void );
extern	int dos_unlock( int, long, long );							/* handle, start of region, size of region */
extern	int dos_write( int, void FAR *, int );
extern	ul get_all_memory( void HUGE ** );							/* pointer to buffer pointer */
extern	int get_filenames( uc *, us, FILE_T FAR *(FAR *)[], us );	/* pathname, file attribute, buffer, buffer size */
extern	int read_entire_file( uc *, void FAR *, ul, ul * );			/* path, buffer, count, amount read */
extern	int write_entire_file( uc *, void FAR *, ul, ul * );		/* path, buffer, count, amount written */
extern	void FAR *create_file_buffer( char *, long * );
extern	int copy_file( uc *, uc * );								/* dest file, source file */
extern	int move_file( uc *, uc * );								/* dest file, source file */
extern	long far_available( void );
extern	int isremote( char );										// Drive # (0=current,1=A,...), returns 1=remote,0=local,-1=bad

extern	us get_date( void );

extern	int start_blinker( int, int, uc * );
extern	int stop_blinker( void );

extern ul _Time_Total_Ticks, _Time_Ticks_Started, _Time_Total_ISRs;
extern us _Time_Year_Started, _Time_Day_Started, _Time_Tick_Rate;

extern void wait_ticks( us );			/* Number of ticks to wait */
extern void wait_usec( ul );			/* Number of microseconds to wait,  ~860 usec resolution */
extern ul	get_ticks( void );			/* Number of ticks since insertion */
extern void start_ticks( us );			/* Sets up all the ISRs and tick counts, # of ticks per second */
extern void stop_ticks( void );			/* Pulls out all the ISRs */

extern us time_insert_process( void (FAR *)(), void FAR * );
extern short time_delete_process( us );		/* Handle from TIME_INSERT_PROCESS function */

extern int dos_add_task( int (FAR *)(), void FAR * );
extern int dos_delete_task( int );
extern int dos_stop_tasks( void );

extern int save_screen( void );
extern int restore_screen( void );
extern int int13( void *, us );

#ifndef	_PRINT_C_
extern	void print( uc *, ... );
#endif

extern	int fprint( int, char *, ... );

#ifndef	_ENTER_C_
extern	us enter_string( int, int, uc *, int, uc, uc * );
#endif

#ifndef	_ENTERINT_C_
extern	int enter_long( int, int, long *, long, long, long, uc );
#endif

#ifndef	_ENTERFLT_C_
extern	int enter_float( int, int, int, double *, double, double, double, uc );
#endif

#ifndef _FREELIST_C_
extern	int free_list( void FAR * );
extern	int free_dlist( void FAR * );
#endif

#ifndef _LINKLIST_C_
extern	void FAR *do_llist_window( int, int, int, int, void FAR *, int, int );
#endif

#ifndef _WN_CLEAR_C_
extern	int wn_clear( WINDOW_T * );
#endif


#ifndef	_WN_CREAT_C_
extern	int wn_create( WINDOW_T *, us,us,us,us, uc *, us, uc, uc );	/* storage, x1,y1,x2,y2, title, type, color, border color */
extern	int wn_free( WINDOW_T * );
#endif


#ifndef	_WN_PRINT_C_
extern	int wn_print( WINDOW_T *, uc *, ... );
#endif


#ifndef	_WN_SCROL_C_
extern	int wn_scroll_up( WINDOW_T * );
extern	int wn_scroll_down( WINDOW_T * );
#endif


#ifndef	_WN_CHAR_C_
extern	int wn_charout( WINDOW_T *, uc, uc );
#endif

#ifndef	_WN_LONG_C_
extern	int wn_enter_long( uc *, long *, long, long, long, uc );
#endif

#ifndef	_WN_INT_C_
extern	int wn_enter_int( uc *, int *, int, int, int, uc );
#endif

#ifndef	_MENU_C_
extern	us menu_bar( MENU_COLOR_T *, MENU_BAR_T * );
#endif


#ifndef _STATUS_C_
extern	uc	_Default_Body_Color;
extern	uc	_Default_Status_Color;
extern	uc	_Default_Title_Color;
extern	uc	_Default_Window_Color;
extern	char _Status_Line_Support;

extern	void display_status( char * );					/* String to display on the status line */
extern	void save_status( void );
extern	void restore_status( void );
extern	ui press_key( void );							/* Display a press any key message and wait for a keypress */
extern	int do_press_window( uc *, uc *, uc );			/* Complex string contents, title of the window, color of the window */
extern	int do_error_window( uc * );					/* Complex string to display *RED* */
extern	int do_warning_window( uc * );					/* Complex string to display *YELLOW* */
extern	int do_status_window( uc * );					/* Complex string to display *BLUE on WHITE* */
extern	int do_start_window( uc * );					/* Complex string to display *BLUE on WHITE* */
extern	void do_end_window( void );
extern	int do_choose_window( uc *, uc *, uc * );		/* Complex string, choice 1, choice 2 */
extern	int do_confirm_window( uc *, int );				/* Complex string, default choice 1=yes, 0=no */
extern	ui do_enter_window( uc *, uc *, int );			/* Complex string, result buffer, length of the buffer */
extern	void display_date( int, int, DOS_DATE_T );		/* X, Y, date in DOS 16-bit format */
#endif


#ifndef	_SEL_FILE_C_
extern	int select_file( char *, char *, int, us, int );
#endif

#ifndef	_SEL_DISK_C_
extern	int select_disk( char, char * );				// default disk 0=current,1=A,...; returns drive number 0=A,..,-1=ESC
#endif

#ifndef	_SORTFILE_C_
extern	void sort_files( FILE_T FAR *(FAR *)[], int, int );
#endif

#ifndef	_LIST_C_
extern	int do_list_window( us, us, int, int, int, char FAR *(FAR *) );
#endif

#ifndef	_FSCAN_C_
extern	int fscan( int, char *, ... );
#endif

extern long seek_read( int, void HUGE *, long, long );
extern long seek_write( int, void HUGE *, long, long );
extern long lock_read_file( int, void HUGE *, long, long, uc );
extern long lock_write_file( int, void HUGE *, long, long, uc );
extern long lock_read_record( int, void HUGE *, long, long, uc );
extern long lock_write_record( int, void HUGE *, long, long, uc );
extern int time_file_lock( int, us );
extern void install_error_handler( void (FAR *)() );
extern void restore_error_handler( void );

#ifndef	_ISAM_C_
extern	int close_index( INDEX_T * );
extern	int open_index( INDEX_T *, uc * );
extern	long get_available_data_entry( int );
extern	int free_data_entry( int, long );
extern	int init_index( uc *, uc *, us );
extern	int init_datafile( uc *, us );
extern	int find_key( INDEX_T *, uc *, us );
extern	int insert_key( INDEX_T *, uc * );
#endif

#ifndef _WN_DATA_C_
extern	int dw_create( us, us, us, us, char *, uc, uc, uc );
extern	int dw_free( int );
extern	int dw_add_entry( int, int, int, us, us, uc, uc, void FAR * );
extern	int dw_open( int, us, int );
extern	int dw_close( int );
#endif

#ifndef _STREDIT_C_
extern	us stredit( int, int, char *, int (*)(), int );
#endif

#ifndef	_DECODE_C_
extern	int decode_file( char *, DECODE_T *, char *, char *, char * );
#endif

#ifndef	_HELP_C_
extern	uc	*Help_Ptr;		/* ->  to a string or a file key	*/
extern	us	Help_Key;		/* Key typed to get help		*/
extern	us	Help_Type;		/* If 0 then no help,
							   if 1 then help file,
							   if 2 then help line			*/
extern	us	Help_X;			/* X coordinate of help window		*/
extern	us	Help_Y;			/* Y coordinate of help window		*/
extern	void do_help( void );
#endif


/*
** Watcom pragmas
*/
#ifdef __WATCOMC__

#pragma aux (MS_C)	atoh;
#pragma aux (MS_C)	raw_out;
#pragma aux (MS_C)	achar_out;
#pragma aux (MS_C)	get_soffset;
#pragma aux (MS_C)	get_segoffset;
#pragma aux (MS_C)	set_soffset;
#pragma aux (MS_C)	_place_cursor;
#pragma aux (MS_C)	get_attribute;
#pragma aux (MS_C)	set_attribute;
#pragma aux (MS_C)	normal_attribute;
#pragma aux (MS_C)	clear_area;
#pragma aux (MS_C)	set_help;
#pragma aux (MS_C)	get_mode;
#pragma aux (MS_C)	set_mode;
#pragma aux (MS_C)	set_screen_segment;
#pragma aux (MS_C)	auto_screen;
#pragma aux (MS_C)	show_cursor;
#pragma aux (MS_C)	no_cursor;
#pragma aux (MS_C)	set_cursor;
#pragma aux (MS_C)	goto_xy;
#pragma aux (MS_C)	get_xy;
#pragma aux (MS_C)	clear_screen;
#pragma aux (MS_C)	clear_line;
#pragma aux (MS_C)	scroll_up;
#pragma aux (MS_C)	scroll_down;
#pragma aux (MS_C)	scroll_screen;
#pragma aux (MS_C)	charin;
#pragma aux (MS_C)	_csr_stub;
#pragma aux (MS_C)	set_key_vector;
#pragma aux (MS_C)	char_out;
#pragma aux (MS_C)	string_out;
#pragma aux (MS_C)	box;
#pragma aux (MS_C)	center;
#pragma aux (MS_C)	displayat_hex;
#pragma aux (MS_C)	displayat_lhex;
#pragma aux (MS_C)	rlhexout;
#pragma aux (MS_C)	rhexout;
#pragma aux (MS_C)	rbyteout;
#pragma aux (MS_C)	new_line;
#pragma aux (MS_C)	set_charin_macro;
#pragma aux (MS_C)	put_time;
#pragma aux (MS_C)	start_timer;
#pragma aux (MS_C)	stop_timer;
#pragma aux (MS_C)	prefix_char;
#pragma aux (MS_C)	prefix_string;
#pragma aux (MS_C)	strip_char;
#pragma aux (MS_C)	strmcat;
#pragma aux (MS_C)	strmcpy;
#pragma aux (MS_C)	make_complex_dir;
#pragma aux (MS_C)	find_longest_substring;
#pragma aux (MS_C)	strtime;
#pragma aux (MS_C)	strdate;
#pragma aux (MS_C)	get_date_string;
#pragma aux (MS_C)	get_time_string;
#pragma aux (MS_C)	read_cmos;
#pragma aux (MS_C)	crc32;
#pragma aux (MS_C)	crc16;
#pragma aux (MS_C)	beep;
#pragma aux (MS_C)	wait_for_retrace;
#pragma aux (MS_C)	par_out;
#pragma aux (MS_C)	par_init;
#pragma aux (MS_C)	par_status;
#pragma aux (MS_C)	wn_open;
#pragma aux (MS_C)	wn_close;
#pragma aux (MS_C)	wn_calc_size;
#pragma aux (MS_C)	wn_reopen;
#pragma aux (MS_C)	choose_one;
#pragma aux (MS_C)	append_file;
#pragma aux (MS_C)	create_file_buffer;
#pragma aux (MS_C)	dos_alloc;
#pragma aux (MS_C)	dos_chdir;
#pragma aux (MS_C)	dos_close;
#pragma aux (MS_C)	dos_create;
#pragma aux (MS_C)	dos_date;
#pragma aux (MS_C)	dos_delete;
#pragma aux (MS_C)	dos_disk_free;
#pragma aux (MS_C)	dos_free;
#pragma aux (MS_C)	dos_getdir;
#pragma aux (MS_C)	dos_getdrive;
#pragma aux (MS_C)	dos_setdrive;
#pragma aux (MS_C)	dos_lock;
#pragma aux (MS_C)	dos_mkdir;
#pragma aux (MS_C)	dos_open;
#pragma aux (MS_C)	dos_read;
#pragma aux (MS_C)	dos_ren;
#pragma aux (MS_C)	dos_resize;
#pragma aux (MS_C)	dos_rmdir;
#pragma aux (MS_C)	dos_seek;
#pragma aux (MS_C)	dos_time;
#pragma aux (MS_C)	dos_unlock;
#pragma aux (MS_C)	dos_write;
#pragma aux (MS_C)	get_all_memory;
#pragma aux (MS_C)	get_filenames;
#pragma aux (MS_C)	read_entire_file;
#pragma aux (MS_C)	write_entire_file;
#pragma aux (MS_C)	copy_file;
#pragma aux (MS_C)	move_file;
#pragma aux (MS_C)	far_available;
#pragma aux (MS_C)	get_date;
#pragma aux (MS_C)	start_blinker;
#pragma aux (MS_C)	stop_blinker;
#pragma aux (MS_C)	wait_ticks;
#pragma aux (MS_C)	wait_usec;
#pragma aux (MS_C)	get_ticks;
#pragma aux (MS_C)	start_ticks;
#pragma aux (MS_C)	stop_ticks;
#pragma aux (MS_C)	time_insert_process;
#pragma aux (MS_C)	time_delete_process;
#pragma aux (MS_C)	dos_add_task;
#pragma aux (MS_C)	dos_delete_task;
#pragma aux (MS_C)	dos_stop_tasks;
#pragma aux (MS_C)	save_screen;
#pragma aux (MS_C)	restore_screen;
#pragma aux (MS_C)	int13;
#pragma aux (MS_C)	print;
#pragma aux (MS_C)	fprint;
#pragma aux (MS_C)	seek_read;
#pragma aux (MS_C)	seek_write;
#pragma aux (MS_C)	lock_read_file;
#pragma aux (MS_C)	lock_write_file;
#pragma aux (MS_C)	lock_read_record;
#pragma aux (MS_C)	lock_write_record;
#pragma aux (MS_C)	time_file_lock;
#pragma aux (MS_C)	install_error_handler;
#pragma aux (MS_C)	restore_error_handler;
#pragma aux (MS_C)	isremote;

#endif

