{ telname.pas -- Display number for telephone "name" by Tom Swan }

program TelName;

var
  i: Integer;
  TelNumber: String;
  TelDial: array[0 .. 9] of String[3];
  LetterSet: set of Char;

{ Return telephone digit that corresponds to a letter C. }
function DigitToLetter(C: Char): Char;
var
  i, j: Integer;
begin
  C := Upcase(C);
  for i := 0 to 9 do
    for j := 1 to 3 do
      if (C = TelDial[i][j]) then
      begin
        DigitToLetter := Chr(i + ord('0'));
        Exit
      end;
  DigitToLetter := C  { Default }
end;

begin
  TelDial[0] := '   ';  TelDial[1] := '   ';
  TelDial[2] := 'ABC';  TelDial[3] := 'DEF';
  TelDial[4] := 'GHI';  TelDial[5] := 'JKL';
  TelDial[6] := 'MNO';  TelDial[7] := 'PRS';
  TelDial[8] := 'TUV';  TelDial[9] := 'WXY';
  LetterSet := ['A' .. 'P', 'R' .. 'Y'];
  Write('Enter telephone name: ');
  Readln(TelNumber);
  for i := 1 to length(TelNumber) do
    Write(DigitToLetter(TelNumber[i]));
  Writeln
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 02/13/1993   Time: 03:17 pm
*)
