#
#  @Project: The cross-platform plug-in toolkit (XPIN).
#  @Project-Version: 1.2
#  @Project-Date: December 1992.
#  @Filename: WXPIN.M
#
#  @Author: Ramin Firoozye - rp&A Inc.
#  @Copyright: (c) 1992, rp&A Inc. - San Francisco, CA.
#  @License.
#  The portable plug-in toolkit source and library code is
#  presented without any warranty or assumption of responsibility
#  from rp&A Inc. and the author. You can not sell this toolkit in
#  source or library form as a standalone product without express
#  permission of rp&A Inc. You are, however, encouraged to use this
#  code in your personal or commercial application without any
#  royalties. You can modify the sources as long as the license
#  and credits are included with the source.
#
#  For bugs, updates, thanks, or suggestions you can contact the
#  author at:
#	CompuServe: 70751,252
#	Internet: rpa@netcom.com
#
#  @End-License.
#
# @Description.
#
# NOTE: This Makefile is for Microsoft NMAKE only!
#
# To invoke it, change the INPUT and OUTPUT definitions to your own 
# settings, then type:
#
#		nmake /f wxpin.m
#
# (This builds the default target defined below in $(OUTPUTFILE)).
#
# You can override these settings either by changing the definitions
# below, or by passing the parameters on the command line.
#
# To override and pass your own plug-in's name on the command line use:
#
#	nmake /f wxpin.m INPUT=your-C-file OUTPUT=plug-in TYPE=file-type
#
# NOTE: INPUT, OUTPUT, and TYPE have to be uppercase. NMAKE strangeness...
#
# To clean up the extra stuff after you build it:
#
#		nmake /f wxpin.m [optional-args] clean
#
# To clean up back to the original state:
#
#		nmake /f wxpin.m [optional-args] delete
#
# [optional-args] are the "INPUT=file OUTPUT=file TYPE=type" values
# that can be passed on the command line (or changed inside this file.
#
# ***** You need to customize the following items for each plug-in.
#
# INPUT - set this to the source file for the plug-in. Defaults to XPINSRC.
#
# OUTPUT - set this to the output binary name of the plug-in. Defaults
#          to XPIN.
#
# TYPE - set this to the file type you want the plug-in to have.
#        This better match the filetype setting in your XPINInit 
#        otherwise nothing will be found. Defaults to "PIN".
#
# NOTE: Don't mess around with the WXPIN.DEF file unless you absolutely have
# to. And if you do, don't change the XPINMAIN definitions unless you change
# them everywhere in the code.
#
# The compile/link settings are for debugging. All optimizations are turned
# off.
#
# @End-Description.
#

# ------- CUSTOMIZE THESE FOR YOUR OWN PLUG-IN --------
!IFNDEF INPUT
INPUT		= XPINSRC
!ENDIF

!IFNDEF OUTPUT
OUTPUT		= XPIN
!ENDIF

!IFNDEF TYPE
TYPE 		= PIN
!ENDIF
# ---------------------- END --------------------------
#

OUTPUTFILE = $(OUTPUT).$(TYPE)
CC  = cl
LINK = link
MODEL = M
CFLAGS  = /G2 /W2 /A$(MODEL)w /GD /Zp /BATCH /f /Zi /Od /Gs
LFLAGS  = /ONERROR:NOEXE /CO /NOF
LLIBS  = LIBW.LIB /NOD:$(MODEL)LIBCE $(MODEL)DLLCEW

FILES  = $(INPUT).C WXPIN.DEF XPINOP.C
OBJS  = $(INPUT).obj XPINOP.obj 


all: $(OUTPUTFILE)

$(INPUT).obj: $(INPUT).C XPIN.H XPINSHR.H XPINTYPE.H
	$(CC) /c $(CFLAGS) /Fo$(INPUT).obj $(INPUT).c

XPINOP.obj: XPINOP.C XPIN.H XPINSHR.H XPINTYPE.H
	$(CC) /c $(CFLAGS) /FoXPINOP.obj XPINOP.C

$(OUTPUTFILE): wxpin.def $(OBJS)
	$(LINK) $(OBJS),$(OUTPUTFILE),NUL,$(LLIBS),wxpin.def $(LFLAGS)

clean:
	del $(INPUT).obj
	del XPINOP.obj

delete: clean
	del $(OUTPUTFILE)

