/*
  @Project: The cross-platform plug-in toolkit (XPIN).
  @Project-Version: 1.2
  @Project-Date: December 1992.
  @Filename: CONFIG.H

  @Author: Ramin Firoozye - rp&A Inc.
  @Copyright: (c) 1992, rp&A Inc. - San Francisco, CA.
  @License.
  The portable plug-in toolkit source and library code is
  presented without any warranty or assumption of responsibility
  from rp&A Inc. and the author. You can not sell this toolkit in
  source or library form as a standalone product without express
  permission of rp&A Inc. You are, however, encouraged to use this
  code in your personal or commercial application without any
  royalties. You can modify the sources as long as the license
  and credits are included with the source.

  For bugs, updates, thanks, or suggestions you can contact the
  author at:
	CompuServe: 70751,252
	Internet: rpa@netcom.com

  @End-License.

  @Description.
  It would be nice if we could compile the same source file on different 
  platforms and get the same result. This compatibility is usually possible
  because almost every platform has a standard C compiler. Most also have
  a C++ compiler. But there are some functions and structures that are
  different across platforms and even development environments. To allow the
  compiler to do all the hard work, we use the C pre-processor. Using a
  series of #define's and #ifdef's, we can isolate the code that is not
  portable. This file merges a lot of settings that different compilers
  define on each platform into a specific set of #defines. The code
  depends on these specific settings to support what it does.
  Basically, this file is a compilation of all the "documented" pre-defined 
  flags I could find for each of these compilers.

  Of course, you can modify this file to suit your taste...

  One last thing. If the IS_SUPPORTED flag is not defined along the way,
  we issue a compiler error and bop out to avoid a zillion warning and error
  messages. If you define your own settings, make sure IS_SUPPORTED
  gets defined properly... Since almost all the compilers are somewhat
  ANSI-C compatible, they all have #ifdef and #error directives. If your
  compiler barfs on these, you might as well give up right there...

  @End-Description.

*/
#ifndef CONFIG_H
#define	CONFIG_H


/*
 * We set a set of constants to the particular compiler and system
 * setting. If no such setting exists, we try to deduce it from
 * some a combination of flag settings as documented with each compiler.
 * The values are defined so that you can bracket the code with
 * #ifdef's suited for each environment.
 *
 * The properties we are looking for are prefixed by:
 *
 *	OS 
 *	COMPILER
 *	LANGUAGE
 *
 * Possible settings are:
 *
 * OS_MAC	- It's a Macintosh
 * OS_WIN	- It's Windows
 * OS_UNIX	- It's Unix
 *
 * COMPILER_MSC		- Microsoft C
 * COMPILER_BORLAND	- Borland C
 * COMPILER_THINK	- Think-C compiler
 * COMPILER_MPW		- MPW C 
 * COMPILER_GNU		- GNU C 
 * 
 * LANGUAGE_C		- C
 * LANGUAGE_CC		- C++
 */

#ifdef IS_SUPPORTED
#undef IS_SUPPORTED
#undef OS_MAC
#undef OS_WIN
#undef OS_SUNOS
#undef COMPILER_MSC
#undef COMPILER_BORLAND
#undef COMPILER_THINK
#undef COMPILER_MPW
#undef COMPILER_GNU
#undef LANGUAGE_C
#undef LANGUAGE_CC
#endif /* IS_SUPPORTED */

/* Check for MSC */
#ifdef MSDOS
#define IS_SUPPORTED 1
#define OS_WIN 1
#define COMPILER_MSC 1
#ifdef __STDC__ 
#define LANGUAGE_C 1
#endif
#ifdef __cplusplus__
#define LANGUAGE_CC 1
#endif
#endif

/* Check for Borland C */
#ifdef __BORLANDC__
#define IS_SUPPORTED 1
#define OS_WIN 1
#define COMPILER_BORLAND 1
#ifdef __STDC__ 
#define LANGUAGE_C
#endif
#ifdef __cplusplus
#define LANGUAGE_CC 1
#endif
#endif

/* Check for Think-C (Mac) */
#ifdef THINK_C
#define IS_SUPPORTED 1
#define OS_MAC 1
#define COMPILER_THINK 1
#ifdef __STDC__
#define LANGUAGE_C
#endif
#endif

/* Check for GNU-C (Unix only) */
#ifdef __GNUC__
#define IS_SUPPORTED
#define COMPILER_GNU
#ifdef unix
#define OS_UNIX
#endif
#ifdef __cplusplus
#define LANGUAGE_CC
#else
#define LANGUAGE_C
#endif
#endif

/* Check for MPW C (Mac) - Not fully tested yet */
#ifdef macintosh
#define IS_SUPPORTED
#define OS_MAC 1
#define COMPILER_MPW 1
#endif

#ifndef IS_SUPPORTED
#error Incompatible development system. Please check CONFIG.H for list.
#endif

#endif

