/*
  @Project: The cross-platform plug-in toolkit (XPIN).
  @Project-Version: 1.2
  @Project-Date: December 1992.
  @Filename: XPIN.H

  @Author: Ramin Firoozye - rp&A Inc.
  @Copyright: (c) 1992, rp&A Inc. - San Francisco, CA.
  @License.
  The portable plug-in toolkit source and library code is
  presented without any warranty or assumption of responsibility
  from rp&A Inc. and the author. You can not sell this toolkit in
  source or library form as a standalone product without express
  permission of rp&A Inc. You are, however, encouraged to use this
  code in your personal or commercial application without any
  royalties. You can modify the sources as long as the license
  and credits are included with the source.

  For bugs, updates, thanks, or suggestions you can contact the
  author at:
	CompuServe: 70751,252
	Internet: rpa@netcom.com

  @End-License.

  @Description.
  These are the definitions used by the plug-in. The definition
  that are common to both caller and plug-in are in XPINSHR.h.
  This file defines the macros that are used inside the plug-in
  itself and declare the header and description. A plug-in without
  these would be just another DLL
  @End-Description.

*/
#ifndef XPIN_H
#define	XPIN_H

#include "XCONFIG.h"

#ifdef OS_WIN
#include <windows.h>
#include <memory.h>
#elif COMPILER_THINK
#include <Types.h>
#include <SetUpA4.h>			// NOTE: this file actually generates inline code
#elif COMPILER_MPW
#include <Types.h>
#include "SAGlobals.h"			// From TN#256
#endif

#include "XPINTYPE.h"			// XPIN data types
#include "XPINSHR.h"			// Caller/PIN shared items

/*
  *
  * - The XPIN macro declares the entry point for the plug-in.
  * - DescribeXPIN(xBlock, Label, Description) is a macro declaration
  *   that has to be on top of every file. NOTE: This macro actually
  *   generates code. It should be called ONLY ONCE in each plug-in.
  *   Local variable declarations should go ABOVE this declaration.
  *   It checks the action code requested and checks to see if it's a
  *   "control" operation (i.e. INIT or DONE). If so, it does the
  *   initialization or termination action. Otherwise, it passes the
  *   request down to the main body of the routine. Of course, this
  *   all happens behind the scenes. The actual XPIN source code
  *   only needs to declare XPIN, then DescribeXPIN and go about it
  *   business. It should call EndXPIN or ExitXPIN before returning.
  *   Plug-ins can return a status value using the XSETSTATx macro.
  *
  *  Mac Note:
  * - EndXTS/ReturnXTS should be the last function called right before returning 
  *   to the main routine.
  */
#ifdef OS_WIN
// extern "C" {
int FAR PASCAL WEP(int nParameter);
int FAR PASCAL _export XPINMAIN(XBlockP b);
// };

#define	XPIN(b)		int FAR PASCAL _export XPINMAIN(XBlockP b)
#define	EndXPIN()		return(0)
#define	ReturnXPIN()	EndXPIN()

#define	DescribeXPIN(x,l,d,m,n) \
	   if ((x)->action < XOP_CONTROL) { \
		switch((x)->action) { \
		    case XOP_INIT: XPINopINIT(x, l, d, m , n); break; \
		    case XOP_DONE: XPINopDONE(x); break; \
		} \
	   ReturnXPIN(); \
	   }

 /*
 * NOTE: The following are just stubs that we need in order to
 * create a DLL. The XTSMAIN function is the main one we call ourselves...
 */
int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg,
			WORD cbHeapSize, LPSTR lpCmdLine) {
	return(1);
}

int FAR PASCAL WEP(int nParameter) {

	return(1);
}

#elif OS_MAC	/* Mac's version has to deal with the A5-world (A4 with Think-C) */

#ifdef COMPILER_THINK
#define	XPIN(b) 		pascal void main(XBlock *b)
#define	EndXPIN()		{ RestoreA4(); return; }

#define	ReturnXPIN()	EndXPIN()
#define	DescribeXPIN(x,l,d,m,n) \
		  RememberA0(); SetUpA4(); \
	 	  if ((x)->action < XOP_CONTROL) { \
			switch((x)->action) { \
			    case XOP_INIT: XPINopINIT(x, l, d, m , n); break; \
			    case XOP_DONE: XPINopDONE(x); break; \
		} \
	   ReturnXPIN(); \
	   }
#elif COMPILER_MPW
#define	XPIN(b) 		pascal void main(XBlock *b)
#define EndXPIN()		{ CloseA5World(theOldA5, theA5Ref); return; }
#define	ReturnXPIN()	EndXPIN()
#define	DescribeXPIN(x,l,d,m,n) \
		A5RefType theA5Ref; long theOldA5; \
		theOldA5 = OpenA5World(&theA5Ref); \
	 	if ((x)->action < XOP_CONTROL) { \
			switch((x)->action) { \
			    case XOP_INIT: XPINopINIT(x, l, d, m , n); break; \
			    case XOP_DONE: XPINopDONE(x); break; \
		} \
	   ReturnXPIN(); \
	   }
#endif

#endif /* OS_MAC */
#endif
