/*
  @Project: The cross-platform plug-in toolkit (XPIN).
  @Project-Version: 1.2
  @Project-Date: December 1992.
  @Filename: XPINSHR.H

  @Author: Ramin Firoozye - rp&A Inc.
  @Copyright: (c) 1992, rp&A Inc. - San Francisco, CA.
  @License.
  The portable plug-in toolkit source and library code is
  presented without any warranty or assumption of responsibility
  from rp&A Inc. and the author. You can not sell this toolkit in
  source or library form as a standalone product without express
  permission of rp&A Inc. You are, however, encouraged to use this
  code in your personal or commercial application without any
  royalties. You can modify the sources as long as the license
  and credits are included with the source.

  For bugs, updates, thanks, or suggestions you can contact the
  author at:
	CompuServe: 70751,252
	Internet: rpa@netcom.com

  @End-License.

  @Description.
  Common definitions used by both the caller and the plug-in.
  @End-Description.

*/
#ifndef	XPINSHR_H
#define	XPINSHR_H

#include "XCONFIG.h"

#ifdef OS_WIN
#include <windows.h>
#elif OS_MAC
#ifdef COMPILER_MPW
#include <Strings.h>
#endif
#endif

#include "XPINTYPE.h"

/*
 * Shared constants
 * Between the caller and the callee...
 */
#define	XTSMAJOR	1	// Major version no. for release of XPIN
#define	XTSMINOR	2	// Minor Version no. for release of XPIN
#define	XPINMAX		100	// maximum number of plug-ins to load
#define	XPINMAGIC	'rf'	// Magic cookie for pin structure
/*
  * The XPINFILE name is the default file type to look for. On the Mac
  * this is the standard filetype associated with each file. Under
  * Windows, this is the standard DOS filename extension to look for.
  * NOTE: To keep the API consistent, this value is passed as a string
  * and by reference. On the Mac, the filetype is passed by value
  * in a longword (4 bytes). The toolkit takes care of the conversion.
  * NOTE: To keep the calling convention consistent across the board, the
  * filetype is passed as a pointer to a string. On the Mac, fileType is
  * passed around by value, and as a long (i.e. 4-bytes). We just
  * strip out the first four bytes of the filetype "string" on the Mac.
  * The difference, is actually merely between 'type' (long) and 
  * "type" (pointer to string).
  *
  * The XPINNAME settings under the Mac translates to the resource
  * type we are searching for inside the XPIN file. On DOS, it
  * is the address of the function to look for inside the XPIN file.
  * This, of course, assumes that each XPIN file contains only one
  * function. This was intentional. In the future, we may want to
  * support XPIN libraries, but the naming convention has to be
  * changed to avoid name-space collisions.
  */
  
#ifdef OS_MAC
#define	XPINFILE	 "xPIN"		// File type to look for (NOTE: It's a string, not a long)
#define	XPINNAME	 'pin!'		// Resource type to look for
#ifdef	COMPILER_THINK
#define	C2P(x)		CtoPstr(x)
#define P2C(x)		PtoCstr(x)
#elif 	COMPILER_MPW
#define	C2P(x)		c2pstr(x)
#define	P2C(x)		p2cstr(x)
#endif
#elif OS_WIN
#define	XPINFILE	  "*.PIN"	    // File type to look for
#define 	XPINNAME  "XPINMAIN"	    // Function to look for in PIN.
#endif

#define	XPINLABEL  80		// Maximum size of label
#define	XPINDESC   128		// Maximum size of description


/* Change this value if you need to pass more parameters through the parameter block */
#define	XBLOCK_MAXARGS		5

// Each element of the parameter block is of type Arg.
// Arg is a union of all standard data types. */

union	Arg {
		Uptr		p;    // Pointer
		Ubyte	b;    // Byte
		Uword	w;    // Word
		Ulong	l;    // Longword
		};
typedef union Arg Arg;

/* The XBlock is the structure for a standard parameter block
   passed between the caller and the plug-in.
   It is kept simple, but obviously could be made more elaborate.
   What is actually passed between the caller and plug-in should
   be pre-designated by the application/plug-in designer.
   To make it really general purpose, the Arg block can be
   made so it carries datatype information. It's basically up
   to the caller/plug-in to decide what's the best way to
   exchange information.
  */
struct	XBlock {
	long	action;	// the action to be performed (XOP)
	Arg	args[XBLOCK_MAXARGS];	// array of args
	Arg	status;			// result sent back from PIN
	};
typedef  struct XBlock XBlock;
#ifdef OS_WIN
typedef  struct XBlock far *XBlockP;
// We need this for calling the DLL's...
typedef	int (_export _far _pascal *XPINFunction)(XBlockP xb);
#elif OS_MAC
typedef  struct XBlock *XBlockP;
#define XPINFunction Handle
#endif


/* The following macros are used to simplify access to the values in
   the XBlock.
       (x) is the address of the XBlock structure.
       (i) is the parameter index (up to XBLOCK_MAXARGS).
       (v) is the value being assigned.
  NOTE: There's a set of macros for the general purpose args,
  and another one for the status field.
  */

#define	XSETb(x, i, v)		(x)->args[i].b = (Ubyte) (v)
#define	XSETw(x,i, v)		(x)->args[i].w = (Uword) (v)
#define	XSETl(x,i,v)		(x)->args[i].l = (Ulong) (v)
#define	XSETp(x,i,v)		(x)->args[i].p = (Uptr) (v)
#define	XGETb(x,i)		((x)->args[i].b)
#define	XGETw(x,i)		((x)->args[i].w)
#define	XGETl(x,i)		((x)->args[i].l)
#define	XGETp(x,i)		((x)->args[i].p)
#define	XSETSTATb(x,v)		(x)->status.b = (Ubyte) (v)
#define	XSETSTATw(x,v)		(x)->status.w = (Uword) (v)
#define	XSETSTATl(x,v)		(x)->status.l = (Ulong) (v)
#define	XSETSTATp(x,v)		(x)->status.p = (Uptr) (v)
#define	XGETSTATb(x)		((x)->status.b)
#define	XGETSTATw(x)		((x)->status.w)
#define	XGETSTATl(x)		((x)->status.l)
#define	XGETSTATp(x)		((x)->status.p)

/*
  * This is a simple version number structure. The DescribeXPIN
  * macro in "XPIN.h" assigns two integers to these values. The
  * caller can retrieve these values for each plug-in through the
  * XPINVersion call.
  */
struct	WVersion	{
			Uword	major;
			Uword	minor;
			};

union	XVersion	{
			struct WVersion W;
			long	L;
			};
typedef union XVersion XVersion;

// Shared function prototypes for plug-in protocol functions
#ifdef OS_WIN
void FAR PASCAL XPINopINIT(XBlockP b, LPSTR l, LPSTR d, int m, int n);
void FAR PASCAL XPINopDONE(XBlockP b);
#elif OS_MAC
void  XPINopINIT(XBlockP b, char *l, char *d, int m, int n);
void  XPINopDONE(XBlockP b);
#endif

/*
  * These are the action opcodes used between the caller and the
  * plug-in. The DescribeXPIN macro filters down and passes on the
  * values less then XOP_CONTROL to a local handler function.
  * Values over that are passed onto the xtension body. If you are
  * designing complex opcodes and subfunctions, add the opcodes to
  * the range above XOP_CONTROL.
  *
  */

#define		XOP_INIT	1	// Used Internally by XPINInit
#define		XOP_DONE	2	// Used Internally by XPINDone
#define		XOP_CONTROL	100
#define		XOP_DO		XOP_CONTROL+1 // Just do stuff

/*
 * Status messages returned by XPIN routines
 * The XPIN routines return internal status of the XPIN mechanism.
 * The XBlock's status field returns the error value for the XPIN itself.
 * XPINErr is defined in XPINTYPE.h
 */
#define		XPINErr			int		// NOTE: It's a signed value

#define 	XPINOK			0		// All is OK
#define		XPINNOMEM		-1		// Out of memory
#define		XPINBADPIN		-2		// Bad PIN file
#define		XPINBADPATH		-3		// Bad PATH spec
#define		XPINBADINDEX	-4		// Bad index passed down (out of range)
#define		XPINFAIL		-100	// General purpose failure
#endif /* XTS_H */
