{ diff.pas -- Algorithm #8: Differential Compression by Tom Swan }

program Diff;

const
  outFName = 'TXT.OUT';

var
  InFName: String;
  InFile, OutFile: Text;
  AWord, Prev: String;

procedure Compress(var W, P: String);
var
  T: String;   { Temporary copy of W }
  I: Integer;  { String index }
begin
  T := W;
  I := 1;
  while (I <= Length(W)) and 
        (I <= Length(P)) and 
        (W[I] = P[I]   ) do
    I := I + 1;
  Delete(W, 1, I - 1);
  W := Chr(I - 1) + W;
  P := T
end;

begin
  Writeln('Differential Compression');
  Write('Input file name? ');
  Readln(InFName);
  Assign(InFile, InFName);
  Reset(InFile);
  Assign(OutFile, outFName);
  Rewrite(OutFile);
  Prev := '';
  Write('Compressing...');
  while not Eof(InFile) do
  begin
    Readln(InFile, AWord);
    Compress(AWord, Prev);
    Writeln(OutFile, AWord)
  end;
  Writeln;
  Close(InFile);
  Close(OutFile);
  Writeln(InFName, ' -> ', outFName)
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 04/07/1993   Time: 08:22 am
*)
