{ instab.pas -- Algorithm #6: Insert Tabs by Tom Swan }

program InsTab;

const
  outFName = 'TXT.OUT';

  tabWidth = 8;  { Try 4 for source code files }
  blank = #32;   { ASCII blank character }
  tab = #09;     { ASCII tab character }

var
  InFName: String;
  InFile, OutFile: Text;
  Line: String;

procedure InsertTabs(var L: String);
var
  T: String;
  J, K: Integer;
  C, Q: Char;
  Eol: Boolean; { End of line }

  function NextChar(var C: Char): Char;
  begin
    C := L[J + 1];
    Eol := C = Q;  { True at end of line }
    NextChar := C
  end;

begin
  T := '';     { Set result T to null }
  Q := #0;     { Sentinel }
  L := L + Q;  { Append sentinal to L }
  K := 0;      { Column count }
  repeat
    J := K;
    while NextChar(C) = blank do
    begin
      J := J + 1;
      if J mod tabWidth = 0 then
      begin
        T := T + tab;
        K := J
      end;
    end;
    while (K < J) do
    begin
      T := T + blank;
      K := K + 1
    end;
    if not Eol then
    begin
      T := T + C;
      K := K + 1
    end;
  until Eol;
  L := T  { Return T via parameter L }
end;

begin
  Writeln('Insert tabs');
  Write('Input file name? ');
  Readln(InFName);
  Assign(InFile, InFName);
  Reset(InFile);
  Assign(OutFile, outFName);
  Rewrite(OutFile);
  Write('Inserting tabs...');
  while not Eof(InFile) do
  begin
    Readln(InFile, Line);
    InsertTabs(Line);
    Writeln(OutFile, Line)
  end;
  Writeln;
  Close(InFile);
  Close(OutFile);
  Writeln(InFName, ' -> ', outFName)
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 04/06/1993   Time: 05:01 pm
*)

