{ remtab.pas -- Algorithm #7: Remove Tabs by Tom Swan }

program RemTab;

const
  outFName = 'TXT.OUT';

  tabWidth = 8;  { Try 4 for source code files }
  blank = #32;   { ASCII blank character }
  tab = #09;     { ASCII tab character }

var
  InFName: String;
  InFile, OutFile: Text;
  Line: String;

procedure RemoveTabs(var L: String);
var
  T: String;
  I: Integer;
  C: Char;
begin
  T := '';
  for I := 1 to Length(L) do
  begin
    C := L[I];
    if C = tab then
      repeat
        T := T + blank
      until Length(T) mod tabWidth = 0
    else
      T := T + C
  end;
  L := T  { Return T via parameter L }
end;

begin
  Writeln('Remove tabs');
  Write('Input file name? ');
  Readln(InFName);
  Assign(InFile, InFName);
  Reset(InFile);
  Assign(OutFile, outFName);
  Rewrite(OutFile);
  Write('Removing tabs...');
  while not Eof(InFile) do
  begin
    Readln(InFile, Line);
    RemoveTabs(Line);
    Writeln(OutFile, Line)
  end;
  Writeln;
  Close(InFile);
  Close(OutFile);
  Writeln(InFName, ' -> ', outFName)
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 04/06/1993   Time: 05:01 pm
*)


