{ undiff.pas -- Algorithm #9: Differential Decompression by Tom Swan }

program UnDiff;

const
  outFName = 'TXT.OUT';

var
  InFName: String;
  InFile, OutFile: Text;
  AWord, Prev: String;

procedure Decompress(var W, P: String);
var
  I: Integer;
begin
  I := Ord(W[1]);
  Delete(W, 1, 1);
  while (I >= 1) do
  begin
    W := P[I] + W;
    I := I - 1
  end;
  P := W
end;

begin
  Writeln('Differential Decompression');
  Write('Input file name? ');
  Readln(InFName);
  Assign(InFile, InFName);
  Reset(InFile);
  Assign(OutFile, outFName);
  Rewrite(OutFile);
  Prev := '';
  Write('Decompressing...');
  while not Eof(InFile) do
  begin
    Readln(InFile, AWord);
    Decompress(AWord, Prev);
    Writeln(OutFile, AWord)
  end;
  Writeln;
  Close(InFile);
  Close(OutFile);
  Writeln(InFName, ' -> ', outFName)
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 04/07/1993   Time: 08:40 am
*)
