/**********************************************************************\
*                                                                      *
* catmas.c -- how to turn a cat into a Christmas tree                  *
*                                                                      *
\**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <fastgraf.h>
#include "rgbtree.h"

const WIDTH = 80;
const HEIGHT = 80;
const BITMAP_SIZE = WIDTH*HEIGHT;

static DACTBL dac_array;
unsigned char bitmap1[BITMAP_SIZE];
unsigned char bitmap2[BITMAP_SIZE];
unsigned char new_bitmap[BITMAP_SIZE];
unsigned char icache[DAC_SIZE][2];
RGBBinTree RGBTree;

int main()
{
   register int i,j;
   int k,n;
   unsigned char color,color1,color2;
   int r1,g1,b1;     /* rgb values for point 1 */
   int r2,g2,b2;     /* rgb values for point 2 */
   int r,g,b;        /* target rgb values */
   int index;

   /* time the process */

   long time1,time2;
   char string[50];

   if (fg_testmode(19,1) == 0)
   {
      printf("\nvga required\n");
      exit(0);
   }

   fg_setmode(19);

   fg_move(0,0);
   fg_disppcx("catmas.pcx",0);
   fg_getdacs(0,256,dac_array);

   RGBTree.build(dac_array);

   fg_move(0,79);
   fg_getimage(bitmap1,WIDTH,HEIGHT);

   fg_move(0,179);
   fg_getimage(bitmap2,WIDTH,HEIGHT);

   n = 10;

   fg_move(0,79);

   time1 = fg_getclock();

   for (i = 0; i < n; i++)
   {
      for (k = 0; k < BITMAP_SIZE; k++)
         new_bitmap[k] = 0;

      for (k = 0; k < BITMAP_SIZE; k++)
      {
         if (new_bitmap[k]) continue;

         /* get the color of the source byte and the target byte */

         color1 = bitmap1[k];
         color2 = bitmap2[k];

         /* get dac values of the source byte */

         index = color1*3;
         r1 = dac_array[index];
         g1 = dac_array[index+1];
         b1 = dac_array[index+2];

         /* get dac values of the target byte */

         index = color2*3;
         r2 = dac_array[index];
         g2 = dac_array[index+1];
         b2 = dac_array[index+2];

         /* calculate rgb values of desired shade */

         r = r1 + ((r2-r1)*i)/n;
         g = g1 + ((g2-g1)*i)/n;
         b = b1 + ((b2-b1)*i)/n;

         /* look at all the colors and find the one closest desired shade */
         /* ( I think this is the part that we need to speed up) */

         color = RGBTree.rgbMatch( r, g, b, 10 );
         new_bitmap[k] = color;
         for (j = k+1; j < BITMAP_SIZE; j++)
           if (bitmap1[j] == color1 && bitmap2[j] == color2)
              new_bitmap[j] = color;
      }

      /* draw the new bitmap on top of the old bitmap */
      fg_drwimage(new_bitmap,WIDTH,HEIGHT);
   }

   /* draw the target bitmap one last time to correct for round off errors */

   fg_drwimage(bitmap2,WIDTH,HEIGHT);
   time2 = fg_getclock();

   fg_waitkey();
   fg_setmode(3);
   fg_reset();

   sprintf(string,"total clock ticks: %ld",time2-time1);
   fg_setcolor(15);
   printf(string);
   printf("\n");

   exit(0);
}


