/***************************************************************************\
*                                                                           *
* clparam.h -- header file for command line parameters parser.              *
*                                                                           *
* 1993-1994, Mark Betz, released to the Public Domain                       *
* version:  1.0                                                             *
* date:     January 23, 1993                                                *
* compiler: Borland C++ 3.0, C++ source and keywords                        *
\***************************************************************************/

#ifndef __CLPARAM__
#define __CLPARAM__

enum cl_result { SCAN_OK, BAD_ARGTYPE, BAD_ARGLEN, NO_DELIM, NO_ARGS };

// The cl_result enum contains constants for the possible return types of the
// scan_clp() function.
//
//               SCAN_OK      :  delimiter sequence found, no errors
//               BAD_ARGTYPE  :  arguments don't match expected type
//               BAD_ARGLEN   :  arguments are longer than expected
//               NO_DELIM     :  requested delimiter/switch seq. not found
//
// See the argtypes enum and comments below for argument types.

enum argtypes { ALPHA, NUMBER, ANY };

// The argtypes enum contains constants for the type of argument expected
// with a given delimiter/switch sequence. The parser will return the
// value of BAD_ARGTYPE when the arguments found do not match the type
// requested.
//               ALPHA        :  alphanumeric text (all printable chars)
//               NUMBER       :  numeric characters only
//               ANY          :  no type checking
//
// These values are passed to the parser in calls to scan_clp()

class ClParam
{
   public:
   ClParam( int argc, char* argv[] );
   int scan( const char* delim, char* buf, const int arglen,
             const int argtype = ANY) const;
   void getProgPath( char* buf ) const;

   protected:
   ClParam() {};
   ClParam( const ClParam& cl ) {};
   operator =( const ClParam& cl ) {};
   int typeCheck( const int argtype, const char* buf ) const;
   int fargc;
   char** fargv;
};

#endif