/***************************************************************************\
*                                                                           *
*  extract.c -- extracts the palette from a pcx to a .PAL file              *
*                                                                           *
*  Useage:  EXTRACT -s[source-file] -o[output-file]                         *
*  Example: extract -stest1.pcx -otest1.pal                                 *
*                                                                           *
*           This program runs in mode 13h (320 x 200 8-bit) mode only.      *
*           It extracts the RGB palette data from the source PCX file,      *
*           and writes it to the output palette file.                       *
*                                                                           *
*  Copyright (c) 1992, Mark Betz, Betz Associates Inc.                      *
\***************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include "rgbtree.h"
#include "clparam.h"

typedef char FPATH[81];

static FPATH spcx;                      // default for source palette
static FPATH opal;                      // default target file
static DACTBL sdacs;                    // palette values from source

// command-line switches:   -s[filename], source pcx filename
//                          -o[filename], target palette filename

int do_clp( int argc, char* argv[] )
{
   int result = 0;
   ClParam clp( argc, argv );

   if (clp.scan( "-s", spcx, 80, ALPHA ) == SCAN_OK)
   {
      if (clp.scan( "-o", opal, 80, ALPHA ) == SCAN_OK)
         result = 1;
   }
   return result;
}

int main( int argc, char* argv[] )
{
   int i;
   FILE* filep;

   clrscr();
   if (do_clp(argc, argv))
   {
      printf("opening source file: %s ...", spcx);
      if ((filep = fopen(spcx, "rb")) == NULL)
      {
         printf("\r\n    -error opening source: %s\r\n", spcx);
         exit(0);
      }
      printf("done.\r\n");
      printf("reading palette data ...");
      fseek(filep, -769L, SEEK_END);
      if (fgetc(filep) != 12)
      {
         printf("\r\n    -error seeking palette: %s\r\n", spcx);
         printf("     this file may not be a 256 color .PCX\r\n");
         fclose(filep);
         exit(0);
      }
      if (fread(sdacs, 1, PAL_SIZE, filep) != PAL_SIZE)
      {
         printf("\r\n    -error reading palette: %s\r\n", spcx);
         fclose(filep);
         exit(0);
      }
      fclose(filep);
      printf("done.\r\n");
      printf("converting pcx color values ...");
      for(i = 0; i < PAL_SIZE; i++)
         sdacs[i] = sdacs[i] >> 2;
      printf("done.\r\n");
      printf("writing output file: %s ...", opal);
      if ((filep = fopen(opal, "wb")) == NULL)
      {
         printf("\r\n    -error creating output file: %s\r\n", opal);
         exit(0);
      }
      if (fwrite(sdacs, 1, PAL_SIZE, filep) != PAL_SIZE)
      {
         printf("\r\n    -error writing output file: %s\r\n", opal);
         fclose(filep);
         exit(0);
      }
      fclose(filep);
      printf("done.\r\n");
   }
   else
   {
      printf("useage:  EXTRACT -s[source-file] -o[output-file]\r\n");
      printf("example: extract -stest1.pcx -otest1.pal\r\n");
      exit(0);
   }
   exit(1);
}











